/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.entry.SingleItemEntry;
import com.sleepycat.je.tree.Key;
import java.nio.ByteBuffer;

public class INDeleteInfo
implements Loggable {
    private long deletedNodeId;
    private byte[] deletedIdKey;
    private DatabaseId dbId;

    public INDeleteInfo(long deletedNodeId, byte[] deletedIdKey, DatabaseId dbId) {
        this.deletedNodeId = deletedNodeId;
        this.deletedIdKey = deletedIdKey;
        this.dbId = dbId;
    }

    public INDeleteInfo() {
        this.dbId = new DatabaseId();
    }

    public long getDeletedNodeId() {
        return this.deletedNodeId;
    }

    public byte[] getDeletedIdKey() {
        return this.deletedIdKey;
    }

    public DatabaseId getDatabaseId() {
        return this.dbId;
    }

    public void optionalLog(LogManager logManager, DatabaseImpl dbImpl) throws DatabaseException {
        if (!dbImpl.isDeferredWriteMode()) {
            logManager.log(new SingleItemEntry(LogEntryType.LOG_IN_DELETE_INFO, this), ReplicationContext.NO_REPLICATE);
        }
    }

    public int getLogSize() {
        return LogUtils.getPackedLongLogSize(this.deletedNodeId) + LogUtils.getByteArrayLogSize(this.deletedIdKey) + this.dbId.getLogSize();
    }

    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writePackedLong(logBuffer, this.deletedNodeId);
        LogUtils.writeByteArray(logBuffer, this.deletedIdKey);
        this.dbId.writeToLog(logBuffer);
    }

    public void readFromLog(ByteBuffer itemBuffer, byte entryVersion) throws LogException {
        boolean unpacked = entryVersion < 6;
        this.deletedNodeId = LogUtils.readLong(itemBuffer, unpacked);
        this.deletedIdKey = LogUtils.readByteArray(itemBuffer, unpacked);
        this.dbId.readFromLog(itemBuffer, entryVersion);
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<INDeleteEntry node=\"").append(this.deletedNodeId);
        sb.append("\">");
        sb.append(Key.dumpString(this.deletedIdKey, 0));
        this.dbId.dumpLog(sb, verbose);
        sb.append("</INDeleteEntry>");
    }

    public long getTransactionId() {
        return 0L;
    }

    public boolean logicalEquals(Loggable other) {
        return false;
    }
}

