/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.visualizer;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import ow.tool.visualizer.OverlayVisualizer;

public final class Main {
    private static final String COMMAND = "owviz";

    private static void usage(String command) {
        System.out.println("usage: " + command + " [-t UDP|TCP] [-i <ID size in bit>]" + " [-s [<self address>][[:]<port>] [--no-upnp]" + " [<host>[:<port>]] [<port>]");
    }

    public static void main(String[] args) {
        String optVal;
        String transport = null;
        int idSizeInBit = 160;
        String selfAddressAndPort = null;
        boolean noUPnP = false;
        Options opts = new Options();
        opts.addOption("h", "help", false, "print help");
        opts.addOption("t", "transport", true, "transpoft, UDP or TCP");
        opts.addOption("i", "idsize", true, "ID size in bit");
        opts.addOption("s", "selfipaddress", true, "self IP address (and port)");
        opts.addOption("N", "no-upnp", false, "disable UPnP address port mapping");
        PosixParser parser = new PosixParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(opts, args);
        }
        catch (ParseException e) {
            System.out.println("There is an invalid option.");
            e.printStackTrace();
            System.exit(1);
        }
        if (cmd.hasOption('h')) {
            Main.usage(COMMAND);
            System.exit(1);
        }
        if ((optVal = cmd.getOptionValue('t')) != null) {
            transport = optVal;
        }
        if ((optVal = cmd.getOptionValue('i')) != null) {
            idSizeInBit = Integer.valueOf(optVal);
        }
        if ((optVal = cmd.getOptionValue('s')) != null) {
            selfAddressAndPort = optVal;
        }
        if (cmd.hasOption('N')) {
            noUPnP = true;
        }
        args = cmd.getArgs();
        String contactHostAndPort = null;
        int contactPort = -1;
        if (args.length >= 1) {
            contactHostAndPort = args[0];
            if (args.length >= 2) {
                contactPort = Integer.parseInt(args[1]);
            }
        }
        try {
            new OverlayVisualizer(transport, idSizeInBit, selfAddressAndPort, noUPnP, contactHostAndPort, contactPort);
        }
        catch (Exception e) {
            System.err.println("Failed to initialize a visualizer.");
            e.printStackTrace();
            System.exit(1);
        }
    }
}

