/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.emulator.commands;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import ow.tool.emulator.EmulatorContext;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.Shell;
import ow.tool.util.shellframework.ShellContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IncludeCommand
implements Command<EmulatorContext> {
    private static final String[] NAMES = new String[]{"include"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "include <file name>";
    }

    @Override
    public boolean execute(ShellContext<EmulatorContext> context) {
        EmulatorContext cxt = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        if (args.length < 1) {
            out.println("include command requires an argument.");
            return !context.isInteractive();
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(args[0]);
        }
        catch (IOException e) {
            out.println("Could not open file: " + args[0]);
        }
        Shell<EmulatorContext> subShell = new Shell<EmulatorContext>(in, out, context.getShellServer(), cxt, false);
        subShell.run();
        return false;
    }
}

