/*
 * Decompiled with CFR 0.152.
 */
package ow.id;

import java.io.Serializable;
import ow.id.ID;
import ow.messaging.MessagingAddress;

public class IDAddressPair
implements Serializable {
    private ID id;
    private MessagingAddress addr;

    public static IDAddressPair getIDAddressPair(ID id, MessagingAddress address) {
        return IDAddressPair.canonicalize(new IDAddressPair(id, address));
    }

    public static IDAddressPair getIDAddressPair(int idSizeInByte, MessagingAddress address) {
        return IDAddressPair.canonicalize(new IDAddressPair(idSizeInByte, address));
    }

    protected IDAddressPair(ID id, MessagingAddress address) {
        this.addr = address;
        this.id = id;
    }

    private IDAddressPair(int idSizeInByte, MessagingAddress address) {
        this.addr = address;
        this.id = this.calculateIDBasedOnHashcodeOfAddress(idSizeInByte);
    }

    private ID calculateIDBasedOnHashcodeOfAddress(int idSizeInByte) {
        if (this.addr != null) {
            return ID.getHashcodeBasedID(this.addr, idSizeInByte);
        }
        return null;
    }

    private static IDAddressPair canonicalize(IDAddressPair obj) {
        return obj;
    }

    public ID getID() {
        return this.id;
    }

    public ID setID(ID id) {
        ID old = this.id;
        this.id = id;
        return old;
    }

    public MessagingAddress getAddress() {
        return this.addr;
    }

    public MessagingAddress setAddressAndRecalculateID(MessagingAddress addr) {
        MessagingAddress old = this.addr;
        this.addr = addr;
        this.id = this.calculateIDBasedOnHashcodeOfAddress(this.id.getSize());
        return old;
    }

    public IDAddressPair getIDAddressPair() {
        return this;
    }

    public int hashCode() {
        if (this.id != null) {
            return this.id.hashCode();
        }
        if (this.addr != null) {
            return this.addr.hashCode();
        }
        return 0;
    }

    public boolean equals(Object o) {
        IDAddressPair other;
        if (o == null) {
            return false;
        }
        try {
            other = (IDAddressPair)o;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (other == null) {
            return false;
        }
        if (this.id != null) {
            return this.id.equals(other.id);
        }
        if (other.id != null) {
            return false;
        }
        return !(this.addr != null ? other.addr != null && !this.addr.equals(other.addr) : other.addr != null);
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int verboseLevel) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.id == null ? "(null)" : this.id.toString(verboseLevel));
        sb.append(":");
        sb.append(this.addr == null ? "(null)" : this.addr.toString(verboseLevel));
        return sb.toString();
    }
}

