/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.util.vizframework;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JComponent;
import ow.id.ID;
import ow.messaging.MessagingAddress;
import ow.messaging.Tag;
import ow.tool.util.vizframework.GeometryManager;
import ow.tool.util.vizframework.IDPairAndTag;
import ow.tool.util.vizframework.ImageManager;
import ow.tool.util.vizframework.MarkPanel;
import ow.tool.util.vizframework.NodePanel;
import ow.tool.util.vizframework.VisualizerFrame;
import ow.tool.util.vizframework.VisualizerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDSpacePanel
extends JComponent
implements KeyListener,
MouseListener,
MouseMotionListener {
    private VisualizerFrame vizFrame;
    private ImageManager imageManager;
    private Map<ID, NodePanel> nodePanelTable = new HashMap<ID, NodePanel>();
    private Set<MessagingEntry> messageSet = new HashSet<MessagingEntry>();
    private Set<MarkEntry> markSet = new HashSet<MarkEntry>();
    private Map<IDPairAndTag, ConnectionEntry> connectionTable = new HashMap<IDPairAndTag, ConnectionEntry>();
    private Map<Integer, Color> colorTable = new HashMap<Integer, Color>();
    private SortedSet<ID> sortedNodeSet = new TreeSet<ID>();
    private Map<ID, Integer> nodeOrderMap = new HashMap<ID, Integer>();
    private BufferedImage buffer = null;
    private Graphics2D offScreenGraphics = null;
    private int lastX;
    private int lastY;

    protected IDSpacePanel(VisualizerFrame vizFrame, ImageManager imageManager) {
        this.vizFrame = vizFrame;
        this.imageManager = imageManager;
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.resetSize();
        ExpiringDaemon r = new ExpiringDaemon();
        Thread t = new Thread(r);
        t.setName("MessageEntry expiring daemon");
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addNode(ID nodeID, MessagingAddress address) {
        int numNodes;
        NodePanel nodePanel = new NodePanel(this.imageManager, nodeID, address);
        Object object = this.nodePanelTable;
        synchronized (object) {
            this.nodePanelTable.put(nodeID, nodePanel);
            numNodes = this.nodePanelTable.size();
        }
        object = this.sortedNodeSet;
        synchronized (object) {
            this.sortedNodeSet.add(nodeID);
            Map<ID, Integer> map = this.nodeOrderMap;
            synchronized (map) {
                int order = 0;
                for (ID id : this.sortedNodeSet) {
                    this.nodeOrderMap.put(id, order++);
                }
            }
        }
        this.add(nodePanel);
        this.vizFrame.imageToBeUpdated(true);
        this.repaint();
        return numNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodePanel removeNode(ID nodeID) {
        NodePanel nodePanel;
        Map<IDPairAndTag, ConnectionEntry> map = this.nodePanelTable;
        synchronized (map) {
            nodePanel = this.nodePanelTable.remove(nodeID);
        }
        map = this.sortedNodeSet;
        synchronized (map) {
            this.sortedNodeSet.remove(nodeID);
            Map<ID, Integer> map2 = this.nodeOrderMap;
            synchronized (map2) {
                this.nodeOrderMap.remove(nodeID);
                int order = 0;
                for (ID id : this.sortedNodeSet) {
                    this.nodeOrderMap.put(id, order++);
                }
            }
        }
        if (nodePanel != null) {
            this.remove(nodePanel);
            nodePanel.setEnabled(false);
            nodePanel.setVisible(false);
        }
        map = this.connectionTable;
        synchronized (map) {
            Iterator<Map.Entry<IDPairAndTag, ConnectionEntry>> it = this.connectionTable.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<IDPairAndTag, ConnectionEntry> setEntry = it.next();
                ConnectionEntry connEntry = setEntry.getValue();
                if (!nodeID.equals(connEntry.from) && !nodeID.equals(connEntry.to)) continue;
                it.remove();
            }
        }
        this.vizFrame.imageToBeUpdated(true);
        this.repaint();
        return nodePanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNumOfNodes() {
        Map<ID, NodePanel> map = this.nodePanelTable;
        synchronized (map) {
            return this.nodePanelTable.size();
        }
    }

    protected Map<ID, Integer> getNodeOrderMap() {
        return this.nodeOrderMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void emphasizeNode(ID nodeID) {
        NodePanel nodePanel = null;
        Map<ID, NodePanel> map = this.nodePanelTable;
        synchronized (map) {
            nodePanel = this.nodePanelTable.get(nodeID);
        }
        if (nodePanel != null) {
            nodePanel.emphasize();
        }
        this.vizFrame.imageToBeUpdated(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMessage(ID src, ID dest, int tag) {
        Set<MessagingEntry> set = this.messageSet;
        synchronized (set) {
            this.messageSet.add(new MessagingEntry(src, dest, tag));
        }
        this.vizFrame.imageToBeUpdated(true);
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMark(ID id, int hint) {
        NodePanel nodePanel = null;
        Map<ID, NodePanel> map = this.nodePanelTable;
        synchronized (map) {
            nodePanel = this.nodePanelTable.get(id);
        }
        if (nodePanel != null) {
            nodePanel.mark();
        }
        if (nodePanel == null) {
            MarkEntry entry = new MarkEntry(this.imageManager, id, hint);
            Set<MarkEntry> set = this.markSet;
            synchronized (set) {
                this.markSet.add(entry);
            }
            this.add(entry.getPanel());
        }
        this.vizFrame.imageToBeUpdated(true);
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMark(MarkEntry entry) {
        boolean removed = false;
        Set<MarkEntry> set = this.markSet;
        synchronized (set) {
            removed = this.markSet.remove(entry);
        }
        if (removed) {
            this.remove(entry.getPanel());
        }
        this.vizFrame.imageToBeUpdated(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectNodes(ID from, ID to, int colorHint) {
        Map<IDPairAndTag, ConnectionEntry> map = this.connectionTable;
        synchronized (map) {
            this.connectionTable.put(new IDPairAndTag(from, to, colorHint), new ConnectionEntry(from, to, colorHint));
        }
        this.vizFrame.imageToBeUpdated(true);
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnectNodes(ID from, ID to, int colorHint) {
        Map<IDPairAndTag, ConnectionEntry> map = this.connectionTable;
        synchronized (map) {
            this.connectionTable.remove(new IDPairAndTag(from, to, colorHint));
        }
        this.vizFrame.imageToBeUpdated(true);
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetSize() {
        GeometryManager geometryManager = this.imageManager.getGeometryManager();
        this.setPreferredSize(new Dimension(geometryManager.getIDSpaceWidth(), geometryManager.getIDSpaceHeight()));
        NodePanel[] nodePanelArray = null;
        Map<ID, NodePanel> map = this.nodePanelTable;
        synchronized (map) {
            int size = this.nodePanelTable.size();
            if (size > 0) {
                nodePanelArray = new NodePanel[size];
                this.nodePanelTable.values().toArray(nodePanelArray);
            }
        }
        if (nodePanelArray != null) {
            for (NodePanel n : nodePanelArray) {
                n.resetSize();
            }
        }
        MarkEntry[] markEntryArray = null;
        Set<MarkEntry> len$ = this.markSet;
        synchronized (len$) {
            int size = this.markSet.size();
            if (size > 0) {
                markEntryArray = new MarkEntry[size];
                this.markSet.toArray(markEntryArray);
            }
        }
        if (markEntryArray != null) {
            for (MarkEntry m : markEntryArray) {
                m.getPanel().resetSize();
            }
        }
        MessagingEntry[] messagingEntryArray = null;
        Set<MessagingEntry> len$2 = this.messageSet;
        synchronized (len$2) {
            int size = this.messageSet.size();
            if (size > 0) {
                messagingEntryArray = new MessagingEntry[size];
                this.messageSet.toArray(messagingEntryArray);
            }
        }
        if (messagingEntryArray != null) {
            for (MessagingEntry m : messagingEntryArray) {
                m.resetSize();
            }
        }
        ConnectionEntry[] connectionEntryArray = null;
        Map<IDPairAndTag, ConnectionEntry> len$3 = this.connectionTable;
        synchronized (len$3) {
            int size = this.connectionTable.size();
            if (size > 0) {
                connectionEntryArray = new ConnectionEntry[size];
                this.connectionTable.values().toArray(connectionEntryArray);
            }
        }
        if (connectionEntryArray != null) {
            for (ConnectionEntry c : connectionEntryArray) {
                c.resetSize();
            }
        }
        int newWidth = geometryManager.getIDSpaceWidth();
        int newHeight = geometryManager.getIDSpaceHeight();
        if (this.buffer == null || this.buffer.getWidth() != newWidth || this.buffer.getHeight() != newHeight) {
            this.buffer = new BufferedImage(newWidth, newHeight, 2);
            this.offScreenGraphics = this.buffer.createGraphics();
        }
        this.offScreenGraphics.setStroke(this.imageManager.getStrokeForMessaging());
        this.vizFrame.imageToBeUpdated(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetLocation() {
        NodePanel[] nodePanelArray = null;
        Map<ID, NodePanel> map = this.nodePanelTable;
        synchronized (map) {
            int size = this.nodePanelTable.size();
            if (size > 0) {
                nodePanelArray = new NodePanel[size];
                this.nodePanelTable.values().toArray(nodePanelArray);
            }
        }
        if (nodePanelArray != null) {
            for (NodePanel n : nodePanelArray) {
                n.resetLocation();
            }
        }
        MarkEntry[] markEntryArray = null;
        Set<MarkEntry> len$ = this.markSet;
        synchronized (len$) {
            int size = this.markSet.size();
            if (size > 0) {
                markEntryArray = new MarkEntry[size];
                this.markSet.toArray(markEntryArray);
            }
        }
        if (markEntryArray != null) {
            for (MarkEntry m : markEntryArray) {
                m.getPanel().resetLocation();
            }
        }
        MessagingEntry[] messagingEntryArray = null;
        Set<MessagingEntry> len$2 = this.messageSet;
        synchronized (len$2) {
            int size = this.messageSet.size();
            if (size > 0) {
                messagingEntryArray = new MessagingEntry[size];
                this.messageSet.toArray(messagingEntryArray);
            }
        }
        if (messagingEntryArray != null) {
            for (MessagingEntry m : messagingEntryArray) {
                m.resetLocation();
            }
        }
        ConnectionEntry[] connectionEntryArray = null;
        Map<IDPairAndTag, ConnectionEntry> len$3 = this.connectionTable;
        synchronized (len$3) {
            int size = this.connectionTable.size();
            if (size > 0) {
                connectionEntryArray = new ConnectionEntry[size];
                this.connectionTable.values().toArray(connectionEntryArray);
            }
        }
        if (connectionEntryArray != null) {
            for (ConnectionEntry c : connectionEntryArray) {
                c.resetLocation();
            }
        }
        this.vizFrame.imageToBeUpdated(true);
    }

    @Override
    public boolean isDoubleBuffered() {
        return false;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        boolean toBeUpdated = this.vizFrame.imageToBeUpdated(false);
        if (toBeUpdated) {
            this.offScreenGraphics.setColor(this.getBackground());
            this.offScreenGraphics.fillRect(0, 0, this.buffer.getWidth(), this.buffer.getHeight());
            this.offScreenGraphics.setStroke(this.imageManager.getStrokeForConnection());
            this.drawConnectionEntriesOnGraphics(this.offScreenGraphics);
            this.offScreenGraphics.setStroke(this.imageManager.getStrokeForMessaging());
            this.drawMessagingEntriesOnGraphics(this.offScreenGraphics);
            this.drawNodePanelsOnGraphics(this.offScreenGraphics);
            this.drawMarkPanelsOnGraphics(this.offScreenGraphics);
        }
        g2.drawImage((Image)this.buffer, 0, 0, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawConnectionEntriesOnGraphics(Graphics2D g2) {
        ConnectionEntry[] connectionEntryArray = null;
        Map<IDPairAndTag, ConnectionEntry> map = this.connectionTable;
        synchronized (map) {
            int size = this.connectionTable.size();
            if (size > 0) {
                connectionEntryArray = new ConnectionEntry[size];
                this.connectionTable.values().toArray(connectionEntryArray);
            }
        }
        if (connectionEntryArray != null) {
            for (ConnectionEntry c : connectionEntryArray) {
                g2.setColor(c.getColor());
                g2.draw(c.getShape());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawMessagingEntriesOnGraphics(Graphics2D g2) {
        MessagingEntry[] messagingEntryArray = null;
        Set<MessagingEntry> set = this.messageSet;
        synchronized (set) {
            int size = this.messageSet.size();
            if (size > 0) {
                messagingEntryArray = new MessagingEntry[size];
                this.messageSet.toArray(messagingEntryArray);
            }
        }
        if (messagingEntryArray != null) {
            for (MessagingEntry m : messagingEntryArray) {
                g2.setColor(m.getColor());
                g2.draw(m.getShape());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawNodePanelsOnGraphics(Graphics2D g2) {
        NodePanel[] nodePanelArray = null;
        Map<ID, NodePanel> map = this.nodePanelTable;
        synchronized (map) {
            int size = this.nodePanelTable.size();
            if (size > 0) {
                nodePanelArray = new NodePanel[size];
                this.nodePanelTable.values().toArray(nodePanelArray);
            }
        }
        if (nodePanelArray != null) {
            for (NodePanel n : nodePanelArray) {
                n.drawComponent(g2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawMarkPanelsOnGraphics(Graphics2D g2) {
        MarkEntry[] markEntryArray = null;
        Set<MarkEntry> set = this.markSet;
        synchronized (set) {
            int size = this.markSet.size();
            if (size > 0) {
                markEntryArray = new MarkEntry[size];
                this.markSet.toArray(markEntryArray);
            }
        }
        if (markEntryArray != null) {
            for (MarkEntry m : markEntryArray) {
                m.getPanel().drawComponent(g2);
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        switch (code) {
            case 81: {
                VisualizerUtil.quit(this, 0);
                break;
            }
            case 82: {
                this.imageManager.getGeometryManager().resetIncline();
                this.resetLocation();
                break;
            }
            case 32: 
            case 78: {
                this.vizFrame.nextGeometryManager();
                break;
            }
            case 8: 
            case 80: 
            case 127: {
                this.vizFrame.previousGeometryManager();
                break;
            }
            case 39: {
                this.lastX = (int)((double)this.lastX + 15.0);
                this.imageManager.getGeometryManager().addIncline(15.0, 0.0);
                this.resetLocation();
                break;
            }
            case 37: {
                this.lastX = (int)((double)this.lastX - 15.0);
                this.imageManager.getGeometryManager().addIncline(-15.0, 0.0);
                this.resetLocation();
                break;
            }
            case 38: {
                this.lastY = (int)((double)this.lastY - 15.0);
                this.imageManager.getGeometryManager().addIncline(0.0, -15.0);
                this.resetLocation();
                break;
            }
            case 40: {
                this.lastY = (int)((double)this.lastY + 15.0);
                this.imageManager.getGeometryManager().addIncline(0.0, 15.0);
                this.resetLocation();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.lastX = e.getX();
        this.lastY = e.getY();
        this.imageManager.getGeometryManager().stopMoment();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.imageManager.getGeometryManager().normalizeIncline();
        this.imageManager.getGeometryManager().startMoment(this);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.imageManager.getGeometryManager().addIncline(x - this.lastX, y - this.lastY);
        this.lastX = x;
        this.lastY = y;
        this.resetLocation();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private class ExpiringDaemon
    implements Runnable {
        private ExpiringDaemon() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    System.err.println("Thread#sleep() interrupted.");
                    e.printStackTrace(System.err);
                    break;
                }
                long threshold = System.currentTimeMillis() - 1000L;
                Map map = IDSpacePanel.this.nodePanelTable;
                synchronized (map) {
                    for (NodePanel n : IDSpacePanel.this.nodePanelTable.values()) {
                        if (n.getEmphasizedTime() > threshold) continue;
                        n.deemphasize();
                        IDSpacePanel.this.vizFrame.imageToBeUpdated(true);
                    }
                }
                boolean changed = false;
                HashSet<MarkEntry> expiredMarkSet = new HashSet<MarkEntry>();
                Iterator i$ = IDSpacePanel.this.markSet;
                synchronized (i$) {
                    for (MarkEntry entry : IDSpacePanel.this.markSet) {
                        if (entry.getAddedTime() > threshold) continue;
                        expiredMarkSet.add(entry);
                        changed = true;
                    }
                }
                if (changed) {
                    for (MarkEntry entry : expiredMarkSet) {
                        IDSpacePanel.this.removeMark(entry);
                        IDSpacePanel.this.vizFrame.imageToBeUpdated(true);
                    }
                }
                changed = false;
                HashSet<MessagingEntry> expiredMessageSet = new HashSet<MessagingEntry>();
                Set set = IDSpacePanel.this.messageSet;
                synchronized (set) {
                    for (MessagingEntry msg : IDSpacePanel.this.messageSet) {
                        if (msg.getAddedTime() <= threshold) {
                            expiredMessageSet.add(msg);
                            changed = true;
                            continue;
                        }
                        int rgb = msg.getColor().getRGB();
                        int alpha = (rgb & 0xFF000000) >>> 24;
                        if ((alpha -= 48) < 0) {
                            alpha = 0;
                        }
                        rgb = rgb & 0xFFFFFF | alpha << 24;
                        Color c = null;
                        Map map2 = IDSpacePanel.this.colorTable;
                        synchronized (map2) {
                            c = (Color)IDSpacePanel.this.colorTable.get(rgb);
                            if (c == null) {
                                c = new Color(rgb, true);
                                IDSpacePanel.this.colorTable.put(rgb, c);
                            }
                        }
                        msg.setColor(c);
                    }
                    if (changed) {
                        IDSpacePanel.this.messageSet.removeAll(expiredMessageSet);
                    }
                    if (!IDSpacePanel.this.messageSet.isEmpty()) {
                        IDSpacePanel.this.vizFrame.imageToBeUpdated(true);
                    }
                }
                IDSpacePanel.this.repaint();
            }
        }
    }

    private class ConnectionEntry {
        private ID from;
        private ID to;
        private Shape shape;
        private Color color;

        ConnectionEntry(ID from, ID to, int colorHint) {
            this.from = from;
            this.to = to;
            if (colorHint < 0) {
                colorHint = -colorHint;
            }
            int colorIndex = colorHint % VisualizerUtil.CONNECTION_COLORS.length;
            this.color = VisualizerUtil.CONNECTION_COLORS[colorIndex];
            int rgb = this.color.getRGB();
            rgb &= 0xFFFFFF;
            this.color = new Color(rgb |= 0xC0000000, true);
            this.resetSize();
        }

        void resetSize() {
            this.shape = IDSpacePanel.this.imageManager.getGeometryManager().getShapeForConnection(this.from, this.to);
        }

        void resetLocation() {
            this.resetSize();
        }

        Shape getShape() {
            return this.shape;
        }

        Color getColor() {
            return this.color;
        }

        Color setColor(Color newColor) {
            Color old = this.color;
            this.color = newColor;
            return old;
        }
    }

    private class MarkEntry {
        private long addedTime = System.currentTimeMillis();
        private ID id;
        private MarkPanel panel;

        MarkEntry(ImageManager imageManager, ID id, int hint) {
            this.id = id;
            this.panel = new MarkPanel(imageManager, id, hint);
        }

        long getAddedTime() {
            return this.addedTime;
        }

        ID getID() {
            return this.id;
        }

        MarkPanel getPanel() {
            return this.panel;
        }
    }

    private class MessagingEntry {
        private long addedTime;
        private ID src;
        private ID dest;
        private Shape shape;
        private Color color;

        MessagingEntry(ID src, ID dest, int tag) {
            this.src = src;
            this.dest = dest;
            this.addedTime = System.currentTimeMillis();
            this.color = Tag.getColor(tag);
            this.resetSize();
        }

        void resetSize() {
            this.shape = IDSpacePanel.this.imageManager.getGeometryManager().getShapeForMessage(this.src, this.dest);
        }

        void resetLocation() {
            this.resetSize();
        }

        long getAddedTime() {
            return this.addedTime;
        }

        Shape getShape() {
            return this.shape;
        }

        Color getColor() {
            return this.color;
        }

        Color setColor(Color newColor) {
            Color old = this.color;
            this.color = newColor;
            return old;
        }
    }
}

