/*
 * Decompiled with CFR 0.152.
 */
package ow.ipmulticast;

import java.net.Inet4Address;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.ipmulticast.Filter;
import ow.ipmulticast.FilterMode;
import ow.ipmulticast.Host;
import ow.ipmulticast.IGMP;
import ow.ipmulticast.VirtualInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Group {
    private static final Logger logger = Logger.getLogger("ipmulticast");
    private final Inet4Address address;
    private final VirtualInterface vif;
    private Filter filter;
    private int lowestIGMPVersion = IGMP.DEFAULT_IGMP_VERSION;
    private Map<Inet4Address, Host> hostMap = new HashMap<Inet4Address, Host>();

    Group(Inet4Address address, VirtualInterface vif) {
        this.address = address;
        this.vif = vif;
        this.updateFilter();
    }

    public Inet4Address getGroupAddress() {
        return this.address;
    }

    public VirtualInterface getVirtualInterface() {
        return this.vif;
    }

    public int getLowestIGMPVersion() {
        return this.lowestIGMPVersion;
    }

    public int numOfHosts() {
        return this.hostMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Host getHost(Inet4Address address) {
        Host host = null;
        Map<Inet4Address, Host> map = this.hostMap;
        synchronized (map) {
            host = this.hostMap.get(address);
        }
        return host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Host registerHost(Inet4Address address, int igmpVersion) {
        Host host = null;
        Map<Inet4Address, Host> map = this.hostMap;
        synchronized (map) {
            host = this.hostMap.get(address);
            if (host != null) {
                if (igmpVersion < host.getIGMPVersion()) {
                    host.setIGMPVersion(igmpVersion);
                }
                host.updateRespondedTime();
            } else {
                boolean isSelf = address.equals(this.vif.getLocalAddress());
                host = new Host(address, igmpVersion, isSelf);
                this.hostMap.put(address, host);
            }
            if (igmpVersion < this.lowestIGMPVersion) {
                this.lowestIGMPVersion = igmpVersion;
            }
        }
        return host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Host unregisterHost(Inet4Address address) {
        Host host = null;
        Map<Inet4Address, Host> map = this.hostMap;
        synchronized (map) {
            host = this.hostMap.remove(address);
            if (host != null && host.getIGMPVersion() <= this.lowestIGMPVersion) {
                int lowestVer = IGMP.DEFAULT_IGMP_VERSION;
                for (Inet4Address addr : this.hostMap.keySet()) {
                    Host h = this.hostMap.get(addr);
                    int ver = h.getIGMPVersion();
                    if (ver >= lowestVer) continue;
                    lowestVer = ver;
                }
                this.lowestIGMPVersion = lowestVer;
            }
        }
        return host;
    }

    public Collection<Host> getAllHost() {
        return this.hostMap.values();
    }

    public synchronized Filter getFilter() {
        return this.filter;
    }

    public synchronized void updateFilter() {
        this.filter = this.calculateFilter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Filter calculateFilter() {
        Filter filter;
        boolean excludeExists = false;
        boolean includeExists = false;
        Map<Inet4Address, Host> map = this.hostMap;
        synchronized (map) {
            for (Host host : this.hostMap.values()) {
                FilterMode filterMode = host.getFilterMode();
                if (filterMode == FilterMode.EXCLUDE) {
                    excludeExists = true;
                    continue;
                }
                includeExists = true;
            }
            FilterMode m = includeExists && !excludeExists ? FilterMode.INCLUDE : FilterMode.EXCLUDE;
            filter = new Filter(m);
            HashSet<Inet4Address> sourceSet = new HashSet<Inet4Address>();
            if (m == FilterMode.EXCLUDE) {
                Set<Inet4Address> set;
                Set<Inet4Address> s;
                for (Host host : this.hostMap.values()) {
                    if (host.getFilterMode() != FilterMode.EXCLUDE) continue;
                    set = s = host.getSourceSet();
                    synchronized (set) {
                        sourceSet.addAll(s);
                    }
                }
                for (Host host : this.hostMap.values()) {
                    if (host.getFilterMode() != FilterMode.INCLUDE) continue;
                    set = s = host.getSourceSet();
                    synchronized (set) {
                        sourceSet.removeAll(s);
                    }
                }
            } else {
                for (Host host : this.hostMap.values()) {
                    Set<Inet4Address> s;
                    Set<Inet4Address> set = s = host.getSourceSet();
                    synchronized (set) {
                        sourceSet.addAll(s);
                    }
                }
            }
            filter.setSourceSet(sourceSet);
        }
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean expire(long expiration) {
        long now = System.currentTimeMillis();
        int lowestVer = 3;
        boolean changed = false;
        HashSet<Inet4Address> removedKeySet = new HashSet<Inet4Address>();
        Map<Inet4Address, Host> map = this.hostMap;
        synchronized (map) {
            for (Inet4Address addr : this.hostMap.keySet()) {
                Host host = this.hostMap.get(addr);
                if (now >= host.getRespondedTime() + expiration) {
                    removedKeySet.add(addr);
                    continue;
                }
                int ver = host.getIGMPVersion();
                if (ver >= lowestVer) continue;
                lowestVer = ver;
            }
            for (Inet4Address removedKey : removedKeySet) {
                this.hostMap.remove(removedKey);
                changed = true;
                logger.log(Level.INFO, removedKey + " expired in a group " + this.address + ".");
            }
        }
        this.lowestIGMPVersion = lowestVer;
        this.updateFilter();
        return changed;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(indent);
        sb.append(this.address);
        sb.append(":IGMPv");
        sb.append(this.lowestIGMPVersion);
        sb.append(" [");
        for (Host h : this.hostMap.values()) {
            sb.append("\n");
            sb.append(indent);
            sb.append(h.toString("  "));
        }
        sb.append("\n");
        sb.append(indent);
        sb.append("]");
        return sb.toString();
    }
}

