/*
 * Copyright (c) 2009, syuu
 * Licensed under the NicoCache License.
 */

package com.dokukino.genkidama;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.positrium.waket.DataServerHandler;
import org.positrium.waket.DataServerMapper;
import org.seasar.framework.container.SingletonS2Container;

import com.sun.net.httpserver.HttpServer;

public class DataServer {
	public static Log logger = LogFactory.getLog(DataServer.class);

	public void bind(int port) throws IOException {

		/**
		 * @see src/resource/dataserver.dicon
		 */
		DataServerMapper mapper = SingletonS2Container
				.getComponent(DataServerMapper.class);

		List<DataServerHandler> list = mapper.getHandleList();

		HttpServer server = HttpServer.create(new InetSocketAddress(port), 0);

		for (DataServerHandler handleObject : list) {
			server.createContext(handleObject.getUri(), handleObject);
		}

		server.start();
	}
}
