package dareka;

import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import dareka.common.CloseUtil;
import dareka.common.Config;
import dareka.common.HttpIOException;
import dareka.processor.HttpRequestHeader;
import dareka.processor.Processor;
import dareka.processor.Resource;

public class ConnectionManager implements Runnable {
	public static Log logger = LogFactory.getLog(ConnectionManager.class);
    private Socket browser;
    private Config config;
    private String processingURI;
    private List<ProcessorEntry> processorEntries =
            new ArrayList<ProcessorEntry>();

    public ConnectionManager(Config config, Socket browser) {
        if (config == null) {
            throw new IllegalArgumentException("config must not be null");
        }
        if (browser == null) {
            throw new IllegalArgumentException("browser must not be null");
        }

        this.config = config;
        this.browser = browser;
    }

    public void run() {
        try {
            while (processAPairOfMessages()) {
                // loop until the method returns false.
                processingURI = null;
            }
            logger.debug("loop end");
        } catch (ConnectException e) {
            // AEgoEhɐڑs
        	logger.debug(e);
            printWarning(e);
        } catch (SocketException e) {
        	logger.debug(e);

            // Connection reset ͂悭̂Œʏ̓OɏoȂ
            if (!isConnectionReset(e)) {
                printWarning(e);
            }
        } catch (HttpIOException e) {
        	logger.debug(e);
        } catch (IOException e) {
            // NIOgĂConnection resetł͂Ȃȉ̃bZ[W
            // IOExceptionɂȂB
            // u̐ڑ̓[g zXgɋIɐؒf܂Bv
            // umꂽڑzXg Rs[^̃\EgEFAɂĒ~܂Bv
            // UnknownHostExceptionʏ탍Oɂ͏oȂ
        	logger.debug(e);
        } catch (Exception e) {
        	logger.debug(e);
            printWarning(e);
        } finally {
            if (!browser.isClosed()) {
                consumeBrowserInput();
                CloseUtil.close(browser);
            }
        }
    }

    private void printWarning(Exception e) {
        logger.warn("failed to process: " + processingURI + "\n\t"
                + e.toString());
    }

    private boolean isConnectionReset(SocketException e) {
        // ̔@ł́c
        return e.getMessage().startsWith("Connection reset")
                || e.getMessage().startsWith("Software caused connection abort");
    }

    /**
     * ]ȃf[^𑗂ĂuEU΍B
     */
    private void consumeBrowserInput() {
        try {
            // java.net APIŏB
            // ̂߂ɔubN[hB
            SocketChannel bc = browser.getChannel();
            // bcnullɂ͂ȂȂB
            bc.configureBlocking(true);

            // ̓ǂݍ݂ŃfbhbN邽ߏo͂͒~B
            // (FIN𑗐M)
            browser.shutdownOutput();

            // IEPOSTNGXg̎ɗ]CRLF𑗂ėĂ̂
            // IEM𐳏Ił悤ɓǂݔ΂ĂB
            // (FIN̎M܂ő҂)
            // ǂݔ΂ĂȂSocket#close()
            // ubZ[WT[o[ɐڑł܂łBvȂǂɂȂ
            // Ql: IE]CRLF𑗐M邱ƂɂĐG
            // Ă̕
            // http://support.microsoft.com/kb/823099/
            while (browser.getInputStream().read() != -1) {
                // no nothing
            }
        } catch (IOException e) {
            // Connection resetñG[B
            // resetĂꍇ͂ł܂OɂȂ邪A
            // ۂread()Ă݂ȂƋʂtȂ̂ŎdȂB
            logger.debug(e.toString() + "(consuming)");
        }
    }

    private boolean processAPairOfMessages() throws IOException {
        HttpRequestHeader requestHeader =
                new HttpRequestHeader(browser.getInputStream());
        processingURI = requestHeader.getURI();

        logger.debug(requestHeader.getMethod() + " "
                + requestHeader.getURI());

        for (ProcessorEntry entry : processorEntries) {
            if (isMatchToEntry(entry, requestHeader)) {
                boolean canContinue =
                        useProcessor(requestHeader, entry.getProcessor());
                logger.debug("end");
                return canContinue;
            }
        }

        throw new HttpIOException("request cannot be processed:\r\n"
                + requestHeader);
    }

    private boolean useProcessor(HttpRequestHeader requestHeader,
            Processor processor) throws IOException {
        Resource resource = processor.onRequest(requestHeader);

        if (resource == null) {
            throw new HttpIOException(
                    "request processor failed to handle request:\r\n"
                            + requestHeader);
        }

        requestHeader.removeHopByHopHeaders();

        return resource.transferTo(browser, requestHeader, config);
    }

    private boolean isMatchToEntry(ProcessorEntry entry,
            HttpRequestHeader requestHeader) {
        if (entry.getMethod() != null) {
            if (!entry.getMethod().equals(requestHeader.getMethod())) {
                return false;
            }
        }

        if (entry.getUri() != null) {
            Matcher m = entry.getUri().matcher(requestHeader.getURI());
            if (!m.lookingAt()) {
                return false;
            }
            // TODO }b`ʂProcessorōėpł悤ɂč
        }

        return true;
    }

    public void addProcessor(String method, Pattern url, Processor processor) {
        if (processor == null) {
            throw new IllegalArgumentException("processor must not be null");
        }

        ProcessorEntry entry = new ProcessorEntry(method, url, processor);

        processorEntries.add(entry);
    }
}
