/*
 * Copyright (c) 2009, syuu
 * Licensed under the NicoCache License.
 */

package com.dokukino.genkidama;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;

public class XmlRpcInvoker {
	@SuppressWarnings("unchecked")
	public static Object invoke(String url, String method, List params) throws MalformedURLException, XmlRpcException {
		return invoke(new URL(url), method, params);
	}

	@SuppressWarnings("unchecked")
	private static Object invoke(URL url, String method, List params) throws XmlRpcException {
		XmlRpcClientConfigImpl conf = new XmlRpcClientConfigImpl();
		conf.setServerURL(url);
		XmlRpcClient client = new XmlRpcClient();
		client.setConfig(conf);
		return client.execute(method, params);
	}

	@SuppressWarnings("unchecked")
	public static Object invoke(String method, List params) throws MalformedURLException, XmlRpcException {
		return invoke(DHTConfig.DHT_STAT_URL, method, params);
	}
}
