/*
 * Copyright 2006-2007 National Institute of Advanced Industrial Science
 * and Technology (AIST), and contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package ow.tool.msgcounter;

/**
 * Counter for number and length of messages.
 */
public class NumberAndLengthCounter {
	private int number;
	private int length;

	public NumberAndLengthCounter() {
		this.reset();
	}

	public synchronized void reset() {
		this.number = 0;
		this.length = 0;
	}

	public int getNumber() { return this.number; }

	public int getLength() { return this.length; }

	public synchronized void addLength(int len) {
		this.number++;
		this.length += len;
	}
}
