package dareka.common;

import java.io.Closeable;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.Selector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import dareka.Main;

/**
 * \[Xclose()Ăԃ[eBeBNXB
 * \[X[N邽߁Aclose()Kvȃ\[Xmۂ
 * Ktry߂̒ŎgpAfinally߂close()KvB
 * colse()IOExceptionthroŵŁAfinally߂̒ł
 * try߂gKvR[fBO璷ɂȂ̂ŁA
 * ̃NXɂ܂Ƃ߂B
 * 
 */
public class CloseUtil {
	public static Log logger = LogFactory.getLog(CloseUtil.class);
    private CloseUtil() {
        // avoid instantiation.
    }

    /**
     * \[XO̔ȂɕB
     * 
     * @param resource 郊\[XBnull̏ꍇ͉ɐB
     * @return trueB炩̃G[falseB
     */
    public static boolean close(Closeable resource) {
        if (resource == null) {
            return true;
        }

        try {
            resource.close();
        } catch (IOException e) {
            logger.debug(e);
            return false;
        }

        return true;
    }

    /**
     * \[XO̔ȂɕB
     * SelectorCloseableȂ̂ŃI[o[[hőΉB
     * 
     * @param resource 郊\[XBnull̏ꍇ͉ɐB
     * @return trueB炩̃G[falseB
     */
    public static boolean close(Selector resource) {
        if (resource == null) {
            return true;
        }

        try {
            resource.close();
        } catch (IOException e) {
            logger.debug(e);
            return false;
        }

        return true;
    }

    /**
     * \[XO̔ȂɕB
     * SocketJava SE 7܂CloseableȂ̂
     * _ł̓I[o[[hőΉB
     * 
     * @param resource 郊\[XBnull̏ꍇ͉ɐB
     * @return trueB炩̃G[falseB
     */
    public static boolean close(Socket resource) {
        if (resource == null) {
            return true;
        }

        try {
            resource.close();
        } catch (IOException e) {
            logger.debug(e);
            return false;
        }

        return true;
    }

    /**
     * \[XO̔ȂɕB
     * ServerSocketJava SE 7܂CloseableȂ̂
     * _ł̓I[o[[hőΉB
     * 
     * @param resource 郊\[XBnull̏ꍇ͉ɐB
     * @return trueB炩̃G[falseB
     */
    public static boolean close(ServerSocket resource) {
        if (resource == null) {
            return true;
        }

        try {
            resource.close();
        } catch (IOException e) {
            logger.debug(e);
            return false;
        }

        return true;
    }

}
