<?xml version="1.0" encoding="UTF-8"?>
<!--
 Copyright (C) MX4J.
 All rights reserved.

 This software is distributed under the terms of the MX4J License version 1.0.
 See the terms of the MX4J License in the documentation provided with this software.

 Author: Carlos Quiroz (tibu@users.sourceforge.net)
 Revision: $Revision: 1.4 $
																																					-->
<xsl:stylesheet version="1.0" xmlns:xalan="http://xml.apache.org/xslt" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output encoding="UTF-8" indent="yes" method="html" xalan:indent-amount="4"/>
  <xsl:param name="head.title">timer.title</xsl:param>
  <xsl:include href="common.xsl"/>
  
  <xsl:template name="domain">
    <xsl:for-each select="Domain[MBean]">
      <xsl:variable name="img-onglet">
        <xsl:choose>
          <xsl:when test="position() = 1">bkgd_onglet_tit.gif</xsl:when>
          <xsl:otherwise>bkgd_onglet_tit2.gif</xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="bgcolor-onglet">
        <xsl:choose>
          <xsl:when test="position() = 1">#660066</xsl:when>
          <xsl:otherwise>#FFFFFF</xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <table border="0" cellpadding="0" cellspacing="0" width="{$pageWidth}">
        <tr>
          <td>
            <img border="0" height="15" src="images/bkgd_onglet_left.gif"/>
          </td>
          <td align="left" bgcolor="#993399" nowrap="nowrap">
            <span class="Titre2">
              <font color="#FFFFFF">
                <b>
                  <xsl:value-of select="@name"/>
                </b>
              </font>
            </span>
          </td>
          <td>
            <img border="0" src="images/{$img-onglet}"/>
          </td>
          <td bgcolor="{$bgcolor-onglet}" width="100%"/>
        </tr>
      </table>
      <table border="0" cellpadding="0" cellspacing="0" width="{$pageWidth}">
      <tr align="left" valign="top">
        <td bgcolor="#993399" class="Titre3black">
          <img height="7" src="images/arrow_s_tit.gif" width="11"/>&#160;<font color="#FFFFFF">
            <b><xsl:call-template name="str">
                <xsl:with-param name="id">timer.table.title</xsl:with-param>
               </xsl:call-template></b>
          </font>
        </td>
        <td bgcolor="#993399" class="Titre3black">
          <img height="10" src="images/poussoir.gif" width="840"/>
        </td>
      </tr>
      <xsl:call-template name="mbean"/>
      <tr>
        <td height="10" colspan="2"/>
      </tr>
      </table>
    </xsl:for-each>
  </xsl:template>
  <xsl:template match="MBean" name="mbean">
    <xsl:for-each select="MBean">
      <xsl:variable name="cellcolor">
        <xsl:if test="(position() mod 2)=1">#CCCCCC</xsl:if>
        <xsl:if test="(position() mod 2)=0">#FFFFFF</xsl:if>
      </xsl:variable>
      <tr bgcolor="{$cellcolor}">
        <xsl:variable name="objectname">
          <xsl:call-template name="uri-encode">
            <xsl:with-param name="uri" select="@objectname"/>
          </xsl:call-template>
        </xsl:variable>
        <td colspan="2" align="left">
          <a href="mbean?objectname={$objectname}">
            <xsl:value-of select="@objectname"/>
          </a>
        </td>
      </tr>
    </xsl:for-each>
  </xsl:template>
  <!-- Main template -->
  <xsl:template match="Server" name="main">
    <html>
      <xsl:call-template name="head"/>
      <body bgcolor="#FFFFFF" leftmargin="0"
        onLoad="MM_preloadImages('images/bkgd_onglet_contact_on.gif','images/btn_top_on.gif')" text="#000000" topmargin="0">
        <xsl:call-template name="toprow">
          <xsl:with-param name="selection">timer</xsl:with-param>
        </xsl:call-template>
        <table border="0" cellpadding="0" cellspacing="0" width="{$pageWidth}">
          <tr bgcolor="#660066">
            <td class="titre1" height="17">&#160; <xsl:call-template name="str">
                <xsl:with-param name="id">timer.main.title</xsl:with-param>
              </xsl:call-template>
            </td>
            <td align="right" class="titre1" height="17" valign="middle">
              <img src="images/titres/tit_temporisateurs_{$request.locale}.gif"/>
            </td>
          </tr>
        </table>
        <xsl:call-template name="domain"/>
        <xsl:call-template name="bottom"/>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
