/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.adaptor.http;

import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Date;
import javax.management.ObjectInstance;
import javax.management.openmbean.OpenType;

public class CommandProcessorUtil {
    private static final DateFormat[] allFormats = new DateFormat[]{DateFormat.getDateInstance(), DateFormat.getTimeInstance(), DateFormat.getDateTimeInstance(), DateFormat.getDateInstance(3), DateFormat.getDateInstance(2), DateFormat.getDateInstance(1), DateFormat.getDateInstance(0), DateFormat.getTimeInstance(3), DateFormat.getTimeInstance(2), DateFormat.getTimeInstance(1), DateFormat.getTimeInstance(0), DateFormat.getDateTimeInstance(3, 3), DateFormat.getDateTimeInstance(3, 2), DateFormat.getDateTimeInstance(3, 1), DateFormat.getDateTimeInstance(3, 0), DateFormat.getDateTimeInstance(2, 3), DateFormat.getDateTimeInstance(2, 2), DateFormat.getDateTimeInstance(2, 1), DateFormat.getDateTimeInstance(2, 0), DateFormat.getDateTimeInstance(1, 3), DateFormat.getDateTimeInstance(1, 2), DateFormat.getDateTimeInstance(1, 1), DateFormat.getDateTimeInstance(1, 0), DateFormat.getDateTimeInstance(0, 3), DateFormat.getDateTimeInstance(0, 2), DateFormat.getDateTimeInstance(0, 1), DateFormat.getDateTimeInstance(0, 0)};
    private static final String[] BASIC_TYPES = new String[]{"int", "long", "short", "byte", "float", "double", "boolean"};
    static /* synthetic */ Class class$0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Object createParameterValue(String parameterType, String parameterValue) throws Exception {
        if (parameterType.equals("java.lang.String")) {
            return parameterValue;
        }
        if (parameterType.equals("java.lang.Integer") || parameterType.equals("int")) {
            parameterValue = parameterValue == null || parameterValue.trim().length() == 0 ? "0" : parameterValue;
            return Integer.valueOf(parameterValue);
        }
        if (parameterType.equals("java.lang.Long") || parameterType.equals("long")) {
            parameterValue = parameterValue == null || parameterValue.trim().length() == 0 ? "0" : parameterValue;
            return Long.valueOf(parameterValue);
        }
        if (parameterType.equals("java.lang.Short") || parameterType.equals("short")) {
            parameterValue = parameterValue == null || parameterValue.trim().length() == 0 ? "0" : parameterValue;
            return Short.valueOf(parameterValue);
        }
        if (parameterType.equals("java.lang.Byte") || parameterType.equals("byte")) {
            parameterValue = parameterValue == null || parameterValue.trim().length() == 0 ? "0" : parameterValue;
            return Byte.valueOf(parameterValue);
        }
        if (parameterType.equals("java.lang.Float") || parameterType.equals("float")) {
            parameterValue = parameterValue == null || parameterValue.trim().length() == 0 ? "0" : parameterValue;
            return Float.valueOf(parameterValue);
        }
        if (parameterType.equals("java.lang.Double") || parameterType.equals("double")) {
            parameterValue = parameterValue == null || parameterValue.trim().length() == 0 ? "0" : parameterValue;
            return Double.valueOf(parameterValue);
        }
        if (parameterType.equals("java.lang.Boolean") || parameterType.equals("boolean")) {
            parameterValue = parameterValue == null || parameterValue.trim().length() == 0 ? "0" : parameterValue;
            return Boolean.valueOf(parameterValue);
        }
        if (parameterType.equals("java.lang.Void")) {
            return Void.TYPE;
        }
        if (parameterType.equals("java.util.Date")) {
            Date value = null;
            int i = 0;
            while (i < allFormats.length) {
                DateFormat dateFormat = allFormats[i];
                synchronized (dateFormat) {
                    try {
                        System.out.println(String.valueOf(parameterValue) + " " + allFormats[i]);
                        value = allFormats[i].parse(parameterValue);
                        break;
                    }
                    catch (ParseException parseException) {
                    }
                }
                ++i;
            }
            if (value == null) {
                throw new ParseException("Not possible to parse", 0);
            }
            return value;
        }
        if (parameterType.equals("java.lang.Number")) {
            Number value = null;
            try {
                parameterValue = parameterValue == null || parameterValue.trim().length() == 0 ? "0" : parameterValue;
                value = Long.valueOf(parameterValue);
            }
            catch (NumberFormatException i) {
                // empty catch block
            }
            if (value == null) {
                try {
                    value = Double.valueOf(parameterValue);
                }
                catch (NumberFormatException i) {
                    // empty catch block
                }
            }
            if (value == null) {
                throw new NumberFormatException("Not possible to parse");
            }
            return value;
        }
        if (parameterType.equals("java.lang.Character") || parameterType.equals("char")) {
            if (parameterValue.length() > 0) {
                return new Character(parameterValue.charAt(0));
            }
            throw new NumberFormatException("Can not initialize Character from empty String");
        }
        Class<?> cls = null;
        Constructor<?> ctor = null;
        try {
            cls = Class.forName(parameterType);
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            ctor = cls.getConstructor(classArray);
            return ctor.newInstance(parameterValue);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException("Invalid parameter type: " + parameterType);
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException("Invalid parameter type: " + parameterType);
        }
        catch (Exception ex) {
            throw ex;
        }
    }

    protected static boolean canCreateParameterValue(String parameterType) {
        int count = OpenType.ALLOWED_CLASSNAMES.length;
        int i = 0;
        while (i < count) {
            if (OpenType.ALLOWED_CLASSNAMES[i].equals(parameterType)) {
                return true;
            }
            ++i;
        }
        count = BASIC_TYPES.length;
        i = 0;
        while (i < count) {
            if (BASIC_TYPES[i].equals(parameterType)) {
                return true;
            }
            ++i;
        }
        Class<?> cls = null;
        try {
            cls = Class.forName(parameterType);
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            cls.getConstructor(classArray);
            return true;
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
        catch (NoSuchMethodException nsme) {
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static Comparator createObjectNameComparator() {
        return new ToStringComparator();
    }

    public static Comparator createObjectInstanceComparator() {
        return new ObjectInstanceComparator();
    }

    public static Comparator createConstructorComparator() {
        return new ConstructorComparator();
    }

    public static Comparator createClassComparator() {
        return new ToStringComparator();
    }

    private static class ToStringComparator
    implements Comparator {
        ToStringComparator() {
        }

        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }

    private static class ObjectInstanceComparator
    implements Comparator {
        private ToStringComparator comp = new ToStringComparator();

        ObjectInstanceComparator() {
        }

        public int compare(Object o1, Object o2) {
            ObjectInstance oi1 = (ObjectInstance)o1;
            ObjectInstance oi2 = (ObjectInstance)o2;
            return this.comp.compare(oi1.getObjectName(), oi2.getObjectName());
        }
    }

    private static class ConstructorComparator
    implements Comparator {
        ConstructorComparator() {
        }

        public int compare(Object o1, Object o2) {
            Class<?>[] params2;
            Constructor c1 = (Constructor)o1;
            Constructor c2 = (Constructor)o2;
            Class<?>[] params1 = c1.getParameterTypes();
            if (params1.length == (params2 = c2.getParameterTypes()).length) {
                int i = 0;
                while (i < params1.length) {
                    if (!params1[i].equals(params2[i])) {
                        return params2[i].toString().compareTo(params1[i].toString());
                    }
                    ++i;
                }
                return 0;
            }
            return params1.length - params2.length;
        }
    }
}

