/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import org.seasar.framework.exception.NotFoundRuntimeException;
import org.seasar.framework.util.ClassLoaderUtil;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.Disposable;
import org.seasar.framework.util.DisposableUtil;

public class ClassPoolUtil {
    protected static final Map classPoolMap = Collections.synchronizedMap(new WeakHashMap());
    protected static boolean initialized;
    static /* synthetic */ Class class$org$seasar$framework$util$ClassPoolUtil;

    public static synchronized void initialize() {
        if (!initialized) {
            DisposableUtil.add(new Disposable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void dispose() {
                    Class clazz = class$org$seasar$framework$util$ClassPoolUtil == null ? (class$org$seasar$framework$util$ClassPoolUtil = ClassPoolUtil.class$("org.seasar.framework.util.ClassPoolUtil")) : class$org$seasar$framework$util$ClassPoolUtil;
                    synchronized (clazz) {
                        classPoolMap.clear();
                        initialized = false;
                    }
                }
            });
            initialized = true;
        }
    }

    public static ClassPool getClassPool(Class targetClass) {
        return ClassPoolUtil.getClassPool(ClassLoaderUtil.getClassLoader(targetClass));
    }

    public static ClassPool getClassPool(ClassLoader classLoader) {
        ClassPoolUtil.initialize();
        ClassPool classPool = (ClassPool)classPoolMap.get(classLoader);
        if (classPool == null) {
            if (classLoader == null) {
                return ClassPool.getDefault();
            }
            classPool = new ClassPool();
            classPool.appendClassPath((ClassPath)new LoaderClassPath(classLoader));
            classPoolMap.put(classLoader, classPool);
        }
        return classPool;
    }

    public static CtClass toCtClass(ClassPool classPool, Class clazz) {
        return ClassPoolUtil.toCtClass(classPool, ClassUtil.getSimpleClassName(clazz));
    }

    public static CtClass toCtClass(ClassPool classPool, String className) {
        try {
            return classPool.get(className);
        }
        catch (NotFoundException e) {
            throw new NotFoundRuntimeException(e);
        }
    }

    public static CtClass[] toCtClassArray(ClassPool classPool, String[] classNames) {
        if (classNames == null) {
            return null;
        }
        CtClass[] result = new CtClass[classNames.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ClassPoolUtil.toCtClass(classPool, classNames[i]);
        }
        return result;
    }

    public static CtClass[] toCtClassArray(ClassPool classPool, Class[] classes) {
        if (classes == null) {
            return null;
        }
        CtClass[] result = new CtClass[classes.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ClassPoolUtil.toCtClass(classPool, classes[i]);
        }
        return result;
    }

    public static CtClass createCtClass(ClassPool classPool, String name) {
        return ClassPoolUtil.createCtClass(classPool, name, Object.class);
    }

    public static CtClass createCtClass(ClassPool classPool, String name, Class superClass) {
        return ClassPoolUtil.createCtClass(classPool, name, ClassPoolUtil.toCtClass(classPool, superClass));
    }

    public static CtClass createCtClass(ClassPool classPool, String name, CtClass superClass) {
        return classPool.makeClass(name, superClass);
    }
}

