/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.interceptors;

import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;
import org.seasar.framework.log.Logger;

public class SimpleTraceInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(SimpleTraceInterceptor.class);

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (!logger.isDebugEnabled()) {
            return invocation.proceed();
        }
        StringBuffer buf = new StringBuffer(100);
        buf.append(this.getTargetClass(invocation).getName());
        buf.append("#");
        buf.append(invocation.getMethod().getName());
        logger.debug("BEGIN " + buf);
        try {
            Object object = invocation.proceed();
            return object;
        }
        catch (Throwable t) {
            buf.append(" Throwable:").append(t);
            throw t;
        }
        finally {
            logger.debug("END " + buf);
        }
    }
}

