/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.LatchSupport;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DbEnvPool {
    private static DbEnvPool pool = new DbEnvPool();
    private Map<String, EnvironmentImpl> envs = new HashMap<String, EnvironmentImpl>();
    private Set<EnvironmentImpl> sharedCacheEnvs = new HashSet<EnvironmentImpl>();

    private DbEnvPool() {
    }

    public static DbEnvPool getInstance() {
        return pool;
    }

    public synchronized int getNSharedCacheEnvironments() {
        return this.sharedCacheEnvs.size();
    }

    private EnvironmentImpl getAnySharedCacheEnv() {
        Iterator<EnvironmentImpl> iter = this.sharedCacheEnvs.iterator();
        return iter.hasNext() ? iter.next() : null;
    }

    public synchronized EnvironmentImpl getEnvironment(File envHome, EnvironmentConfig config, boolean checkImmutableParams, boolean openIfNeeded, boolean replicationIntended) throws DatabaseException {
        String environmentKey = this.getEnvironmentMapKey(envHome);
        EnvironmentImpl envImpl = this.envs.get(environmentKey);
        if (envImpl != null) {
            envImpl.checkIfInvalid();
            assert (envImpl.isOpen());
            if (checkImmutableParams) {
                envImpl.checkImmutablePropsForEquality(config);
            }
            envImpl.incReferenceCount();
        } else if (openIfNeeded) {
            EnvironmentImpl sharedCacheEnv = config.getSharedCache() ? this.getAnySharedCacheEnv() : null;
            envImpl = new EnvironmentImpl(envHome, config, sharedCacheEnv, replicationIntended);
            assert (config.getSharedCache() == envImpl.getSharedCache());
            this.addEnvironment(envImpl);
        }
        return envImpl;
    }

    synchronized void reinitEnvironment(EnvironmentImpl envImpl, boolean replicationIntended) throws DatabaseException {
        assert (!this.envs.containsKey(this.getEnvironmentMapKey(envImpl.getEnvironmentHome())));
        assert (!this.sharedCacheEnvs.contains(envImpl));
        EnvironmentImpl sharedCacheEnv = envImpl.getSharedCache() ? this.getAnySharedCacheEnv() : null;
        envImpl.doReinit(replicationIntended, sharedCacheEnv);
        this.addEnvironment(envImpl);
    }

    synchronized void setMutableConfig(EnvironmentImpl envImpl, EnvironmentMutableConfig mutableConfig) throws DatabaseException {
        envImpl.doSetMutableConfig(mutableConfig);
        if (envImpl.getSharedCache()) {
            this.resetSharedCache(envImpl.getMemoryBudget().getMaxMemory(), envImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void closeEnvironment(EnvironmentImpl envImpl, boolean doCheckpoint, boolean doCheckLeaks) throws DatabaseException {
        if (envImpl.decReferenceCount()) {
            try {
                envImpl.doClose(doCheckpoint, doCheckLeaks);
            }
            finally {
                this.removeEnvironment(envImpl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void closeEnvironmentAfterRunRecovery(EnvironmentImpl envImpl) throws DatabaseException {
        try {
            envImpl.doCloseAfterRunRecovery();
        }
        finally {
            this.removeEnvironment(envImpl);
        }
    }

    private void addEnvironment(EnvironmentImpl envImpl) throws DatabaseException {
        envImpl.incReferenceCount();
        this.envs.put(this.getEnvironmentMapKey(envImpl.getEnvironmentHome()), envImpl);
        if (envImpl.getSharedCache()) {
            this.sharedCacheEnvs.add(envImpl);
            assert (envImpl.getEvictor().checkEnvs(this.sharedCacheEnvs));
            this.resetSharedCache(-1L, envImpl);
        }
    }

    private void removeEnvironment(EnvironmentImpl envImpl) throws DatabaseException {
        boolean found;
        String environmentKey = this.getEnvironmentMapKey(envImpl.getEnvironmentHome());
        boolean bl = found = this.envs.remove(environmentKey) != null;
        if (this.sharedCacheEnvs.remove(envImpl)) {
            assert (found && envImpl.getSharedCache());
            assert (envImpl.getEvictor().checkEnvs(this.sharedCacheEnvs));
            if (this.sharedCacheEnvs.isEmpty()) {
                envImpl.getEvictor().shutdown();
            } else {
                envImpl.getMemoryBudget().subtractCacheUsage();
                this.resetSharedCache(-1L, null);
            }
        } else assert (!found || !envImpl.getSharedCache());
        if (this.envs.isEmpty()) {
            LatchSupport.clearNotes();
        }
    }

    public synchronized void clear() {
        this.envs.clear();
    }

    private String getEnvironmentMapKey(File file) throws DatabaseException {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new DatabaseException(e);
        }
    }

    private void resetSharedCache(long newMaxMemory, EnvironmentImpl skipEnv) throws DatabaseException {
        for (EnvironmentImpl envImpl : this.sharedCacheEnvs) {
            if (envImpl == skipEnv) continue;
            envImpl.getMemoryBudget().reset(newMaxMemory, false, envImpl.getConfigManager());
        }
    }
}

