/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp.messages;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sbbi.upnp.messages.StateVariableResponse;
import net.sbbi.upnp.messages.StateVariableResponseParser;
import net.sbbi.upnp.messages.UPNPResponseException;
import net.sbbi.upnp.services.ServiceStateVariable;
import net.sbbi.upnp.services.UPNPService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StateVariableMessage {
    private static final Log log = LogFactory.getLog((Class)StateVariableMessage.class);
    private UPNPService service;
    private ServiceStateVariable serviceStateVar;

    protected StateVariableMessage(UPNPService service, ServiceStateVariable serviceStateVar) {
        this.service = service;
        this.serviceStateVar = serviceStateVar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StateVariableResponse service() throws IOException, UPNPResponseException {
        StateVariableResponse rtrVal = null;
        UPNPResponseException upnpEx = null;
        IOException ioEx = null;
        StringBuffer body = new StringBuffer(256);
        body.append("<?xml version=\"1.0\"?>\r\n");
        body.append("<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\"");
        body.append(" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">");
        body.append("<s:Body>");
        body.append("<u:QueryStateVariable xmlns:u=\"urn:schemas-upnp-org:control-1-0\">");
        body.append("<u:varName>").append(this.serviceStateVar.getName()).append("</u:varName>");
        body.append("</u:QueryStateVariable>");
        body.append("</s:Body>");
        body.append("</s:Envelope>");
        if (log.isDebugEnabled()) {
            log.debug((Object)("POST prepared for URL " + this.service.getControlURL()));
        }
        URL url = new URL(this.service.getControlURL().toString());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setRequestMethod("POST");
        HttpURLConnection.setFollowRedirects(false);
        conn.setRequestProperty("HOST", url.getHost() + ":" + url.getPort());
        conn.setRequestProperty("SOAPACTION", "\"urn:schemas-upnp-org:control-1-0#QueryStateVariable\"");
        conn.setRequestProperty("CONTENT-TYPE", "text/xml; charset=\"utf-8\"");
        conn.setRequestProperty("CONTENT-LENGTH", Integer.toString(body.length()));
        OutputStream out = conn.getOutputStream();
        out.write(body.toString().getBytes());
        out.flush();
        conn.connect();
        InputStream input = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("executing query :\n" + body));
        }
        try {
            input = conn.getInputStream();
        }
        catch (IOException ex) {
            input = conn.getErrorStream();
        }
        if (input != null) {
            int response = conn.getResponseCode();
            String responseBody = this.getResponseBody(input);
            if (log.isDebugEnabled()) {
                log.debug((Object)("received response :\n" + responseBody));
            }
            SAXParserFactory saxParFact = SAXParserFactory.newInstance();
            saxParFact.setValidating(false);
            saxParFact.setNamespaceAware(true);
            StateVariableResponseParser msgParser = new StateVariableResponseParser(this.serviceStateVar);
            StringReader stringReader = new StringReader(responseBody);
            InputSource src = new InputSource(stringReader);
            try {
                SAXParser parser = saxParFact.newSAXParser();
                parser.parse(src, (DefaultHandler)msgParser);
            }
            catch (ParserConfigurationException confEx) {
                throw new RuntimeException("ParserConfigurationException during SAX parser creation, please check your env settings:" + confEx.getMessage());
            }
            catch (SAXException saxEx) {
                upnpEx = new UPNPResponseException(899, saxEx.getMessage());
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException ex) {}
            }
            if (upnpEx == null) {
                if (response == 200) {
                    rtrVal = msgParser.getStateVariableResponse();
                } else if (response == 500) {
                    upnpEx = msgParser.getUPNPResponseException();
                } else {
                    ioEx = new IOException("Unexpected server HTTP response:" + response);
                }
            }
        }
        try {
            out.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        conn.disconnect();
        if (upnpEx != null) {
            throw upnpEx;
        }
        if (rtrVal == null && ioEx == null) {
            ioEx = new IOException("Unable to receive a response from the UPNP device");
        }
        if (ioEx != null) {
            throw ioEx;
        }
        return rtrVal;
    }

    private String getResponseBody(InputStream in) throws IOException {
        byte[] buffer = new byte[256];
        int readen = 0;
        StringBuffer content = new StringBuffer(256);
        while ((readen = in.read(buffer)) != -1) {
            content.append(new String(buffer, 0, readen));
        }
        int len = content.length();
        while (content.charAt(len - 1) == '\u0000') {
            content.setLength(--len);
        }
        return content.toString().trim();
    }
}

