/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.CommandInfo;
import javax.activation.CommandMap;
import javax.activation.DataContentHandler;
import javax.activation.MimeType;

public class MailcapCommandMap
extends CommandMap {
    private final Map preferredCommands;
    private final Map allCommands;
    private URL url;
    private ClassLoader cl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailcapCommandMap() {
        File file;
        InputStream is;
        block26: {
            this.preferredCommands = new HashMap();
            this.allCommands = new HashMap();
            try {
                InputStream is2 = MailcapCommandMap.class.getResourceAsStream("/META-INF/mailcap.default");
                if (is2 == null) break block26;
                try {
                    this.parseMailcap(is2);
                }
                finally {
                    is2.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            this.cl = MailcapCommandMap.class.getClassLoader();
            Enumeration<URL> e = this.cl.getResources("META-INF/mailcap");
            while (e.hasMoreElements()) {
                this.url = e.nextElement();
                try {
                    is = this.url.openStream();
                    try {
                        this.parseMailcap(is);
                    }
                    finally {
                        is.close();
                    }
                }
                catch (IOException e1) {}
            }
        }
        catch (SecurityException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            file = new File(System.getProperty("java.home"), "lib/mailcap");
            is = new FileInputStream(file);
            try {
                this.parseMailcap(is);
            }
            finally {
                is.close();
            }
        }
        catch (SecurityException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            file = new File(System.getProperty("user.home"), ".mailcap");
            is = new FileInputStream(file);
            try {
                this.parseMailcap(is);
            }
            finally {
                is.close();
            }
        }
        catch (SecurityException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailcapCommandMap(String fileName) throws IOException {
        this();
        FileReader reader = new FileReader(fileName);
        try {
            this.parseMailcap(reader);
        }
        finally {
            reader.close();
        }
    }

    public MailcapCommandMap(InputStream is) {
        this();
        this.parseMailcap(is);
    }

    private void parseMailcap(InputStream is) {
        try {
            this.parseMailcap(new InputStreamReader(is));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void parseMailcap(Reader reader) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(reader);
        while ((line = br.readLine()) != null) {
            this.addMailcap(line);
        }
    }

    public synchronized void addMailcap(String mail_cap) {
        int index = 0;
        if ((index = this.skipSpace(mail_cap, index)) == mail_cap.length() || mail_cap.charAt(index) == '#') {
            return;
        }
        int start = index;
        if (start == (index = this.getToken(mail_cap, index))) {
            return;
        }
        String mimeType = mail_cap.substring(start, index);
        if ((index = this.skipSpace(mail_cap, index)) == mail_cap.length() || mail_cap.charAt(index) == '#') {
            return;
        }
        if (mail_cap.charAt(index) == '/') {
            ++index;
            start = index = this.skipSpace(mail_cap, index);
            index = this.getToken(mail_cap, index);
            mimeType = mimeType + '/' + mail_cap.substring(start, index);
        } else {
            mimeType = mimeType + "/*";
        }
        index = this.skipSpace(mail_cap, index);
        if (index == mail_cap.length() || mail_cap.charAt(index) != ';') {
            return;
        }
        if ((index = this.getMText(mail_cap, index)) == mail_cap.length() || mail_cap.charAt(index) != ';') {
            return;
        }
        while (index < mail_cap.length() && mail_cap.charAt(index) == ';') {
            start = index = this.skipSpace(mail_cap, index + 1);
            index = this.getToken(mail_cap, index);
            String fieldName = mail_cap.substring(start, index).toLowerCase();
            if ((index = this.skipSpace(mail_cap, index)) >= mail_cap.length() || mail_cap.charAt(index) != '=') continue;
            start = index = this.skipSpace(mail_cap, index + 1);
            index = this.getMText(mail_cap, index);
            String value = mail_cap.substring(start, index);
            index = this.skipSpace(mail_cap, index);
            if (!fieldName.startsWith("x-java-") || fieldName.length() <= 7) continue;
            String command = fieldName.substring(7);
            this.addCommand(mimeType, command, value.trim());
        }
    }

    private void addCommand(String mimeType, String cmdName, String commandClass) {
        CommandInfo info = new CommandInfo(cmdName, commandClass);
        HashMap<String, CommandInfo> commands = (HashMap<String, CommandInfo>)this.preferredCommands.get(mimeType);
        if (commands == null) {
            commands = new HashMap<String, CommandInfo>();
            this.preferredCommands.put(mimeType, commands);
        }
        commands.put(info.getCommandName(), info);
        ArrayList<CommandInfo> cmdList = (ArrayList<CommandInfo>)this.allCommands.get(mimeType);
        if (cmdList == null) {
            cmdList = new ArrayList<CommandInfo>();
            this.allCommands.put(mimeType, cmdList);
        }
        cmdList.add(info);
    }

    private int skipSpace(String s, int index) {
        while (index < s.length() && Character.isWhitespace(s.charAt(index))) {
            ++index;
        }
        return index;
    }

    private int getToken(String s, int index) {
        while (index < s.length() && s.charAt(index) != '#' && !MimeType.isSpecial(s.charAt(index))) {
            ++index;
        }
        return index;
    }

    private int getMText(String s, int index) {
        while (index < s.length()) {
            char c = s.charAt(index);
            if (c == '#' || c == ';' || Character.isISOControl(c)) {
                return index;
            }
            if (c == '\\' && ++index == s.length()) {
                return index;
            }
            ++index;
        }
        return index;
    }

    public synchronized CommandInfo[] getPreferredCommands(String mimeType) {
        Map commands = (Map)this.preferredCommands.get(mimeType.toLowerCase());
        if (commands == null) {
            commands = (Map)this.preferredCommands.get(this.getWildcardMimeType(mimeType));
        }
        if (commands == null) {
            return new CommandInfo[0];
        }
        return commands.values().toArray(new CommandInfo[commands.size()]);
    }

    public synchronized CommandInfo[] getAllCommands(String mimeType) {
        int i;
        List wildCommands;
        List exactCommands = (List)this.allCommands.get(mimeType = mimeType.toLowerCase());
        if (exactCommands == null) {
            exactCommands = Collections.EMPTY_LIST;
        }
        if ((wildCommands = (List)this.allCommands.get(this.getWildcardMimeType(mimeType))) == null) {
            wildCommands = Collections.EMPTY_LIST;
        }
        CommandInfo[] result = new CommandInfo[exactCommands.size() + wildCommands.size()];
        int j = 0;
        for (i = 0; i < exactCommands.size(); ++i) {
            result[j++] = (CommandInfo)exactCommands.get(i);
        }
        for (i = 0; i < wildCommands.size(); ++i) {
            result[j++] = (CommandInfo)wildCommands.get(i);
        }
        return result;
    }

    public synchronized CommandInfo getCommand(String mimeType, String cmdName) {
        Map commands;
        int i = (mimeType = mimeType.toLowerCase()).indexOf(59);
        if (i != -1) {
            mimeType = mimeType.substring(0, i).trim();
        }
        if ((commands = (Map)this.preferredCommands.get(mimeType.toLowerCase())) == null) {
            commands = (Map)this.preferredCommands.get(this.getWildcardMimeType(mimeType));
        }
        if (commands == null) {
            return null;
        }
        return (CommandInfo)commands.get(cmdName.toLowerCase());
    }

    private String getWildcardMimeType(String mimeType) {
        int i = mimeType.indexOf(47);
        if (i == -1) {
            return mimeType + "/*";
        }
        return mimeType.substring(0, i + 1) + "*";
    }

    public synchronized DataContentHandler createDataContentHandler(String mimeType) {
        CommandInfo info = this.getCommand(mimeType, "content-handler");
        if (info == null) {
            return null;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        try {
            return (DataContentHandler)cl.loadClass(info.getCommandClass()).newInstance();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InstantiationException e) {
            return null;
        }
    }
}

