/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.scenariogen.commands;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Random;
import ow.tool.scenariogen.ScenarioGeneratorContext;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PutCommand
implements Command<ScenarioGeneratorContext> {
    private static final String[] NAMES = new String[]{"put"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "put <start time (ms)> <interval (ms)> <# of puts>";
    }

    @Override
    public boolean execute(ShellContext<ScenarioGeneratorContext> context) {
        ScenarioGeneratorContext cxt = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        if (args.length < 3) {
            out.println("Usage: " + this.getHelp());
            return false;
        }
        long startTime = (long)Double.parseDouble(args[0]);
        long interval = (long)Double.parseDouble(args[1]);
        int repeat = Integer.parseInt(args[2]);
        PrintWriter writer = cxt.getWriter();
        Random rnd = new Random();
        int numNodes = cxt.getNumberOfNodes();
        long time = startTime;
        for (int i = 0; i < repeat; ++i) {
            StringBuilder sb = new StringBuilder();
            sb.append("schedule ");
            sb.append(time);
            sb.append(" control ");
            sb.append(rnd.nextInt(numNodes) + 1);
            sb.append(" put k");
            sb.append(i);
            sb.append(" v");
            sb.append(i);
            writer.println(sb.toString());
            time += interval;
        }
        writer.flush();
        out.println("finish at " + (double)time / 1000.0);
        return false;
    }
}

