/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.scenariogen;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import ow.tool.scenariogen.ScenarioGeneratorContext;
import ow.tool.scenariogen.commands.ChurnCommand;
import ow.tool.scenariogen.commands.GetCommand;
import ow.tool.scenariogen.commands.HaltCommand;
import ow.tool.scenariogen.commands.HelpCommand;
import ow.tool.scenariogen.commands.JoinCommand;
import ow.tool.scenariogen.commands.MputgetCommand;
import ow.tool.scenariogen.commands.OutCommand;
import ow.tool.scenariogen.commands.PutCommand;
import ow.tool.scenariogen.commands.QuitCommand;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.MessagePrinter;
import ow.tool.util.shellframework.Shell;
import ow.tool.util.shellframework.ShellServer;

public class Main {
    private static final String COMMAND = "owscenariogen";
    public static final String ENCODING = "UTF-8";
    public static final int DEFAULT_TTL = 604800;
    public static final String DEFAULT_SCENARIO_FILENAME = "scenario";
    private static final Class[] COMMANDS = new Class[]{HelpCommand.class, JoinCommand.class, PutCommand.class, GetCommand.class, MputgetCommand.class, HaltCommand.class, ChurnCommand.class, OutCommand.class, QuitCommand.class};
    private static final List<Command<ScenarioGeneratorContext>> commandList = ShellServer.createCommandList(COMMANDS);
    private static final Map<String, Command<ScenarioGeneratorContext>> commandTable = ShellServer.createCommandTable(commandList);
    private BufferedWriter out;

    public static void main(String[] args) {
        Main gen = new Main();
        try {
            gen.start(args);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void usage() {
        System.out.print("Usage: owscenariogen");
        System.out.println(" <# of nodes> [<output file>]");
    }

    public void start(String[] args) throws IOException {
        if (args.length < 1) {
            Main.usage();
            System.exit(1);
        }
        int numNodes = Integer.parseInt(args[0]);
        ScenarioGeneratorContext context = new ScenarioGeneratorContext(numNodes);
        String fileName = DEFAULT_SCENARIO_FILENAME;
        if (args.length >= 2) {
            fileName = args[1];
        }
        context.setWriter(new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), ENCODING))));
        Shell<ScenarioGeneratorContext> shell = new Shell<ScenarioGeneratorContext>(System.in, System.out, commandTable, commandList, new ShowPromptPrinter(), new NoCommandPrinter(), null, context, true);
        shell.run();
    }

    public BufferedWriter getWriter() {
        return this.out;
    }

    private static class NoCommandPrinter
    implements MessagePrinter {
        private NoCommandPrinter() {
        }

        public void execute(PrintStream out, String hint) {
            out.print("No such command");
            if (hint != null) {
                out.print(": " + hint);
            } else {
                out.print(".");
            }
            out.print("\r\n");
            out.flush();
        }
    }

    private static class ShowPromptPrinter
    implements MessagePrinter {
        private ShowPromptPrinter() {
        }

        public void execute(PrintStream out, String hint) {
            out.print("Ready.\r\n");
            out.flush();
        }
    }
}

