/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.emulator.commands;

import java.io.PrintStream;
import ow.tool.emulator.EmulatorContext;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RemoteCommand
implements Command<EmulatorContext> {
    private static final String[] NAMES = new String[]{"remote"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "remote {connect,directory [<current dir>],javapath [<java command path>],jvmoption [<java options>]}";
    }

    @Override
    public boolean execute(ShellContext<EmulatorContext> context) {
        EmulatorContext cxt = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        if (args.length < 1) {
            out.println("remote command requires an argument.");
            return !context.isInteractive();
        }
        StringBuilder sb = new StringBuilder();
        if (args.length >= 2) {
            sb.append(args[1]);
            for (int i = 2; i < args.length; ++i) {
                sb.append(" ");
                sb.append(args[i]);
            }
        }
        String option = sb.toString();
        String command = args[0];
        if (command.startsWith("c")) {
            out.println("establish connections.");
            cxt.establishControlPipes();
        } else if (command.startsWith("d")) {
            out.println("remote directory: " + option);
            cxt.setRemoteDirectory(option);
        } else if (command.startsWith("ja")) {
            out.println("remote javapath: " + option);
            cxt.setRemoteJavaPath(option);
        } else if (command.startsWith("jv")) {
            out.println("remote jvmoption: " + option);
            cxt.setRemoteJVMOption(option);
        } else {
            out.println("No such command: remote " + command);
            return !context.isInteractive();
        }
        return false;
    }
}

