/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging.emulator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.messaging.ExtendedMessageHandler;
import ow.messaging.Message;
import ow.messaging.MessageHandler;
import ow.messaging.MessageReceiver;
import ow.messaging.MessageSender;
import ow.messaging.MessagingAddress;
import ow.messaging.emulator.EmuHostID;
import ow.messaging.emulator.EmuMessageSender;
import ow.messaging.emulator.EmuMessagingAddress;
import ow.messaging.emulator.EmuMessagingConfiguration;
import ow.messaging.emulator.EmuMessagingProvider;
import ow.messaging.emulator.SleepPeriodMeasure;
import ow.stat.MessagingReporter;
import ow.stat.StatConfiguration;
import ow.stat.StatFactory;
import ow.util.concurrent.GlobalThreadPoolExecutors;

public final class EmuMessageReceiver
implements MessageReceiver {
    private static final Logger logger = Logger.getLogger("messaging");
    private static Map<EmuMessagingAddress, EmuMessageReceiver> receiverTable = new ConcurrentHashMap<EmuMessagingAddress, EmuMessageReceiver>();
    final EmuMessagingConfiguration config;
    private EmuMessagingAddress selfAddr;
    protected final EmuMessagingProvider provider;
    private final EmuMessageSender singletonSender;
    private final MessagingReporter msgReporter;
    private List<MessageHandler> handlerList = new ArrayList<MessageHandler>();
    private List<ExtendedMessageHandler> extendedHandlerList = new ArrayList<ExtendedMessageHandler>();
    private int numExtendedHandler = 0;
    private long latencyMillis;
    private int latencyNanos;
    private final SleepPeriodMeasure sleepPeriodMeasure;
    final boolean communicationCanFail;
    private static boolean oomPrinted = false;

    protected EmuMessageReceiver(EmuMessagingConfiguration config, EmuHostID selfInetAddr, int port, EmuMessagingProvider provider) {
        this.config = config;
        this.selfAddr = new EmuMessagingAddress(selfInetAddr, port);
        this.provider = provider;
        this.singletonSender = new EmuMessageSender(this);
        StatConfiguration conf = StatFactory.getDefaultConfiguration();
        this.msgReporter = StatFactory.getMessagingReporter(conf, this.provider, this.getSender());
        long latencyMicros = config.getAdditionalLatencyMicros();
        if (latencyMicros > 0L) {
            this.latencyMillis = latencyMicros / 1000L;
            this.latencyNanos = (int)(latencyMicros - 1000L * this.latencyMillis) * 1000;
            this.sleepPeriodMeasure = new SleepPeriodMeasure();
        } else {
            this.sleepPeriodMeasure = null;
        }
        this.communicationCanFail = config.getCommunicationFailureRate() > 0.0;
    }

    public MessagingAddress getSelfAddress() {
        return this.selfAddr;
    }

    public void setSelfAddress(String hostname) {
        this.selfAddr = (EmuMessagingAddress)this.provider.getMessagingAddress(hostname, this.selfAddr.getPort());
    }

    public int getPort() {
        return this.selfAddr.getPort();
    }

    public MessagingReporter getMessagingReporter() {
        return this.msgReporter;
    }

    public void start() {
        receiverTable.put(this.selfAddr, this);
    }

    public synchronized void stop() {
        receiverTable.remove(this.selfAddr);
    }

    public MessageSender getSender() {
        return this.singletonSender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandler(MessageHandler handler) {
        List<MessageHandler> list = this.handlerList;
        synchronized (list) {
            this.handlerList.add(handler);
            try {
                this.extendedHandlerList.add((ExtendedMessageHandler)handler);
                ++this.numExtendedHandler;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHandler(MessageHandler handler) {
        List<MessageHandler> list = this.handlerList;
        synchronized (list) {
            this.handlerList.remove(handler);
            try {
                this.extendedHandlerList.remove((ExtendedMessageHandler)handler);
                --this.numExtendedHandler;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    protected static EmuMessageReceiver getReceiver(MessagingAddress dest) {
        EmuMessageReceiver receiver = null;
        receiver = receiverTable.get(dest);
        return receiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message processAMessage(final Message msg) {
        if (this.sleepPeriodMeasure != null) {
            try {
                this.sleepPeriodMeasure.sleep(this.latencyMillis, this.latencyNanos);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        Message ret = null;
        for (MessageHandler handler : this.handlerList) {
            try {
                ret = handler.process(msg);
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "A MessageHandler threw an Exception.", e);
            }
        }
        if (this.numExtendedHandler > 0) {
            Runnable r = new Runnable(){

                public void run() {
                    for (ExtendedMessageHandler handler : EmuMessageReceiver.this.extendedHandlerList) {
                        try {
                            handler.postProcess(msg);
                        }
                        catch (Throwable e) {
                            logger.log(Level.SEVERE, "A MessageHandler threw an Exception.", e);
                        }
                    }
                }
            };
            try {
                if (this.config.getUseThreadPool()) {
                    ExecutorService ex = GlobalThreadPoolExecutors.getThreadPool(false, false, Thread.currentThread().isDaemon());
                    ex.submit(r);
                } else {
                    Thread t = new Thread(r);
                    t.setDaemon(false);
                    t.setName("EmuMessageReceiver (post-process): " + msg);
                    t.start();
                }
            }
            catch (OutOfMemoryError e) {
                try {
                    Thread.currentThread().setPriority(10);
                }
                catch (SecurityException e1) {
                    // empty catch block
                }
                logger.log(Level.SEVERE, "# of threads: " + Thread.activeCount(), e);
                boolean doesPrint = false;
                Class<EmuMessageReceiver> clazz = EmuMessageReceiver.class;
                synchronized (EmuMessageReceiver.class) {
                    if (!oomPrinted) {
                        oomPrinted = true;
                        doesPrint = true;
                    }
                    // ** MonitorExit[var6_12] (shouldn't be in output)
                    if (doesPrint) {
                        Thread[] tarray = new Thread[Thread.activeCount()];
                        Thread.enumerate(tarray);
                        for (Thread t : tarray) {
                            if (t == null) continue;
                            System.out.println("Th: " + t.getName());
                        }
                        System.out.flush();
                        Runtime.getRuntime().halt(1);
                    }
                    throw e;
                }
            }
        }
        if (this.sleepPeriodMeasure != null) {
            try {
                this.sleepPeriodMeasure.sleep(this.latencyMillis, this.latencyNanos);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return ret;
    }
}

