/*
 * Decompiled with CFR 0.152.
 */
package ow.ipmulticast;

import java.net.Inet4Address;
import java.util.HashSet;
import java.util.Set;
import ow.ipmulticast.FilterMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Filter {
    private FilterMode filterMode;
    private Set<Inet4Address> sourceSet;

    public Filter(FilterMode filterMode) {
        this.filterMode = filterMode;
        this.sourceSet = new HashSet<Inet4Address>();
    }

    public boolean doBlock(Inet4Address source) {
        boolean contained = this.sourceSet.contains(source);
        if (this.filterMode == FilterMode.EXCLUDE) {
            return contained;
        }
        return !contained;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setSourceSet(Set<Inet4Address> sourceSet) {
        this.sourceSet.clear();
        Set<Inet4Address> set = sourceSet;
        synchronized (set) {
            this.sourceSet.addAll(sourceSet);
        }
    }

    public synchronized void addSource(Inet4Address address) {
        this.sourceSet.add(address);
    }

    public synchronized boolean removeSource(Inet4Address address) {
        return this.sourceSet.remove(address);
    }
}

