/*
 * Decompiled with CFR 0.152.
 */
package ow.directory.expiration;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpiringValue<V>
implements Serializable {
    private V value;
    private long expire;

    ExpiringValue(V value, long ttl) {
        this.value = value;
        this.expire = ttl >= 0L ? System.currentTimeMillis() + ttl : Long.MAX_VALUE;
    }

    public long getExpiringTime() {
        return this.expire;
    }

    public V getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object o) {
        try {
            ExpiringValue other = (ExpiringValue)o;
            if (!this.value.equals(other.value)) {
                return false;
            }
        }
        catch (ClassCastException e) {
            return false;
        }
        return true;
    }

    public String toString() {
        return "{expire=" + this.expire + ", value=" + this.value + "}";
    }
}

