/*
 * Decompiled with CFR 0.152.
 */
package ow.directory;

import ow.directory.DirectoryConfiguration;
import ow.directory.MultiValueDirectory;
import ow.directory.SingleValueDirectory;
import ow.directory.expiration.ExpiringMultiValueDirectory;
import ow.directory.expiration.ExpiringSingleValueDirectory;
import ow.directory.expiration.ExpiringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DirectoryProvider {
    public abstract String getName();

    public <K, V> SingleValueDirectory<K, V> openSingleValueDirectory(Class typeK, Class typeV, String workingDir, String dbName, DirectoryConfiguration config) throws Exception {
        if (config == null) {
            config = DirectoryConfiguration.getDefaultConfiguration();
        }
        if (config.getExpirationTime() < 0L) {
            return this.provideSingleValueDirectory(typeK, typeV, workingDir, dbName, config);
        }
        SingleValueDirectory<K, V> dir = this.provideSingleValueDirectory(typeK, ExpiringValue.class, workingDir, dbName, config);
        return new ExpiringSingleValueDirectory(dir, config.getExpirationTime());
    }

    public <K, V> MultiValueDirectory<K, V> openMultiValueDirectory(Class typeK, Class typeV, String workingDir, String dbName, DirectoryConfiguration config) throws Exception {
        if (config == null) {
            config = DirectoryConfiguration.getDefaultConfiguration();
        }
        if (config.getExpirationTime() < 0L) {
            return this.provideMultiValueDirectory(typeK, typeV, workingDir, dbName, config);
        }
        MultiValueDirectory<K, V> dir = this.provideMultiValueDirectory(typeK, ExpiringValue.class, workingDir, dbName, config);
        return new ExpiringMultiValueDirectory(dir, config.getExpirationTime());
    }

    public abstract void removeDirectory(String var1, String var2) throws Exception;

    protected abstract <K, V> SingleValueDirectory<K, V> provideSingleValueDirectory(Class var1, Class var2, String var3, String var4, DirectoryConfiguration var5) throws Exception;

    protected abstract <K, V> MultiValueDirectory<K, V> provideMultiValueDirectory(Class var1, Class var2, String var3, String var4, DirectoryConfiguration var5) throws Exception;
}

