/*
 * Decompiled with CFR 0.152.
 */
package ow.dht;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.dht.DHT;
import ow.dht.DHTConfiguration;
import ow.dht.impl.BasicDHTProvider;
import ow.dht.impl.CHTProvider;
import ow.dht.impl.ChurnTolerantDHTProvider;
import ow.dht.impl.DHTProvider;
import ow.dht.memcached.impl.MemcachedProvider;
import ow.id.ID;
import ow.messaging.Signature;
import ow.routing.RoutingService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DHTFactory {
    private static final Logger logger = Logger.getLogger("dht");
    private static final Class[] PROVIDERS = new Class[]{ChurnTolerantDHTProvider.class, BasicDHTProvider.class, CHTProvider.class, MemcachedProvider.class};
    private static final Map<String, DHTProvider> providerTable = new HashMap<String, DHTProvider>();
    private static final Map<String, Integer> idTable = new HashMap<String, Integer>();

    public static DHTConfiguration getDefaultConfiguration() {
        return new DHTConfiguration();
    }

    public static <V extends Serializable> DHT<V> getDHT(DHTConfiguration config) throws Exception {
        DHTProvider provider = providerTable.get(config.getImplementationName());
        return provider.getDHT(Signature.getAllAcceptingApplicationID(), Signature.getAllAcceptingApplicationVersion(), config, null);
    }

    public static <V extends Serializable> DHT<V> getDHT(DHTConfiguration config, ID selfID) throws Exception {
        DHTProvider provider = providerTable.get(config.getImplementationName());
        return provider.getDHT(Signature.getAllAcceptingApplicationID(), Signature.getAllAcceptingApplicationVersion(), config, selfID);
    }

    public static <V extends Serializable> DHT<V> getDHT(short applicationID, short applicationVersion, DHTConfiguration config) throws Exception {
        DHTProvider provider = providerTable.get(config.getImplementationName());
        return provider.getDHT(applicationID, applicationVersion, config, null);
    }

    public static <V extends Serializable> DHT<V> getDHT(short applicationID, short applicationVersion, DHTConfiguration config, ID selfID) throws Exception {
        DHTProvider provider = providerTable.get(config.getImplementationName());
        return provider.getDHT(applicationID, applicationVersion, config, selfID);
    }

    public static <V extends Serializable> DHT<V> getDHT(DHTConfiguration config, RoutingService routingSvc) throws Exception {
        DHTProvider provider = providerTable.get(config.getImplementationName());
        return provider.getDHT(config, routingSvc);
    }

    static {
        int id = 1;
        for (Class clazz : PROVIDERS) {
            Object o;
            try {
                o = clazz.newInstance();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not instantiate an object of the class: " + clazz, e);
                continue;
            }
            if (!(o instanceof DHTProvider)) continue;
            DHTProvider provider = (DHTProvider)o;
            for (String dhtName : provider.getNames()) {
                providerTable.put(dhtName, provider);
                idTable.put(dhtName, id);
            }
            ++id;
        }
    }
}

