/*
 * Decompiled with CFR 0.152.
 */
package ow.dht;

import java.io.Serializable;
import java.util.Set;
import ow.dht.ByteArray;
import ow.dht.DHTConfiguration;
import ow.dht.ValueInfo;
import ow.id.ID;
import ow.routing.RoutingException;
import ow.util.HighLevelService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface DHT<V extends Serializable>
extends HighLevelService {
    public void clearDHTState();

    public Set<ValueInfo<V>> put(ID var1, V var2) throws Exception;

    public Set<ValueInfo<V>> put(ID var1, V[] var2) throws Exception;

    public Set<ValueInfo<V>>[] put(PutRequest<V>[] var1) throws Exception;

    public Set<ValueInfo<V>> get(ID var1) throws RoutingException;

    public Set<ValueInfo<V>>[] get(ID[] var1);

    public Set<ValueInfo<V>> remove(ID var1, V[] var2, ByteArray var3) throws RoutingException;

    public Set<ValueInfo<V>> remove(ID var1, ID[] var2, ByteArray var3) throws RoutingException;

    public Set<ValueInfo<V>> remove(ID var1, ByteArray var2) throws RoutingException;

    public Set<ValueInfo<V>>[] remove(RemoveRequest<V>[] var1, ByteArray var2);

    public ByteArray setHashedSecretForPut(ByteArray var1);

    public long setTTLForPut(long var1);

    public Set<ID> getLocalKeys();

    public Set<ValueInfo<V>> getLocalValues(ID var1);

    public Set<ID> getGlobalKeys();

    public Set<ValueInfo<V>> getGlobalValues(ID var1);

    @Override
    public DHTConfiguration getConfiguration();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class RemoveRequest<V>
    extends PutRequest<V> {
        private final ID[] valueHash;

        public RemoveRequest(ID key, V[] values) {
            super(key, values);
            this.valueHash = null;
        }

        public RemoveRequest(ID key, ID[] valueHash) {
            super(key, null);
            this.valueHash = valueHash;
        }

        public RemoveRequest(ID key) {
            super(key, null);
            this.valueHash = null;
        }

        public ID[] getValueHash() {
            return this.valueHash;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{ key: ").append(((PutRequest)this).key.toString());
            if (((PutRequest)this).values != null) {
                sb.append(", value:");
                for (Object v : ((PutRequest)this).values) {
                    sb.append(" ").append(v);
                }
            } else if (this.valueHash != null) {
                sb.append(", vlaueHash:");
                for (ID vh : this.valueHash) {
                    sb.append(" ").append(vh.toString());
                }
            }
            sb.append(" }");
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PutRequest<V>
    implements Serializable {
        private final ID key;
        private final V[] values;

        public PutRequest(ID key, V[] values) {
            this.key = key;
            this.values = values;
        }

        public ID getKey() {
            return this.key;
        }

        public V[] getValues() {
            return this.values;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{ key: ").append(this.key.toString());
            if (this.values != null) {
                sb.append(", value:");
                for (V v : this.values) {
                    sb.append(" ").append(v);
                }
            }
            sb.append(" }");
            return sb.toString();
        }
    }
}

