/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dxo.util;

import java.lang.reflect.Method;
import org.seasar.extension.dxo.util.Expression;
import org.seasar.extension.dxo.util.OgnlExpression;
import org.seasar.extension.dxo.util.SimpleExpressionParser;
import org.seasar.framework.util.MethodUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.Tokenizer;

public class DxoUtil {
    protected static final Method GET_VALUE_TYPE_OF_TARGET_MAP_METHOD = DxoUtil.getValueTypeOfTargetMapMethod();

    public static Class getElementTypeOfList(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return parameterTypes.length == 1 ? MethodUtil.getElementTypeOfListFromReturnType((Method)method) : MethodUtil.getElementTypeOfListFromParameterType((Method)method, (int)1);
    }

    public static Class getValueTypeOfTargetMap(Method method) {
        if (GET_VALUE_TYPE_OF_TARGET_MAP_METHOD == null) {
            return null;
        }
        return (Class)MethodUtil.invoke((Method)GET_VALUE_TYPE_OF_TARGET_MAP_METHOD, null, (Object[])new Object[]{method});
    }

    protected static Method getValueTypeOfTargetMapMethod() {
        try {
            Class<?> clazz = Class.forName("org.seasar.extension.dxo.util.DxoTigerUtil");
            return clazz.getMethod("getValueTypeOfTargetMap", Method.class);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Expression parseRule(String rule) {
        if (StringUtil.isEmpty((String)rule)) {
            return null;
        }
        Expression exp = SimpleExpressionParser.parse(rule);
        if (exp == null) {
            exp = new OgnlExpression(rule);
        }
        return exp;
    }

    protected static String addQuote(String expr) {
        MyTokenizer tokenizer = new MyTokenizer(expr);
        StringBuffer buf = new StringBuffer(expr.length() + 10);
        int token = tokenizer.nextToken();
        while (token != -1) {
            if (token != 39 && token != -3) {
                throw new IllegalArgumentException(expr + "(" + token + ")");
            }
            buf.append('\'').append(tokenizer.getStringValue()).append('\'');
            token = tokenizer.nextToken();
            if (token != 58) {
                throw new IllegalArgumentException(expr + "(" + token + ")");
            }
            buf.append((char)token);
            token = tokenizer.nextToken();
            if (token == 39) {
                buf.append('\'').append(tokenizer.getStringValue()).append('\'');
            } else if (token == -3) {
                buf.append(tokenizer.getStringValue());
            } else {
                throw new IllegalArgumentException(expr + "(" + token + ")");
            }
            token = tokenizer.nextToken();
            if (token == 44) {
                buf.append((char)token);
                token = tokenizer.nextToken();
                continue;
            }
            if (token == -1) break;
            throw new IllegalArgumentException(expr + "(" + token + ")");
        }
        return buf.toString();
    }

    protected static class MyTokenizer
    extends Tokenizer {
        public static final int TT_COLON = 58;
        public static final int TT_COMMA = 44;
        private static byte[] defaultCtype = new byte[256];

        public MyTokenizer(String str) {
            this(str, defaultCtype);
        }

        public MyTokenizer(String str, byte[] ctype) {
            super(str, ctype);
        }

        protected static void setup(byte[] ctype2) {
            Tokenizer.setup((byte[])ctype2);
            MyTokenizer.ordinaryChar((byte[])ctype2, (int)58);
            MyTokenizer.ordinaryChar((byte[])ctype2, (int)44);
        }

        static {
            MyTokenizer.setup(defaultCtype);
        }
    }
}

