/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishimoto [atmark] m.ieice.org)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: BreakOutItem.java,v 1.2 2009/01/28 13:51:17 nishimoto Exp $
 */

package galatea.outitem;

import galatea.dialog.RuntimeError;
import galatea.relaxer.pdoc.*;


public class BreakOutItem extends OutItem
{
	String script_ = "";
	
	public BreakOutItem(double msec)
	{
		this(msec, true);
	}
	

	private String _double2script(double sec)
	{
		// return "'" + Double.toString(sec) + "'";
		return Double.toString(sec);
	}
	
	public BreakOutItem(double msec, boolean bargein)
	{
		isInstant_ = false;
		script_ = _double2script(msec);
		//bargein_ = bargein;
	}
	
	public BreakOutItem(PdocBreak pb)
	{
		isInstant_ = false;
		
		//bargein_ = pb.getBargein();
		
		String content = pb.getContent();
		if ( content == null ) {
			script_ = _double2script(pb.getLength());
		} else {
			script_ = content;
		}
	}
	
	public BreakOutItem(String script, boolean bargein)
	{
		isInstant_ = false;
		//bargein_ = bargein;
		script_ = script;
	}
	
	public void doEvaluate() throws RuntimeError
	{
		arg_ = ecmascript_.evaluate(script_); 
	}
	
	
	public double getArgAsDouble() 
	{ 
		if ( arg_.equals("undefined") ) {
			return 5.0;
		}
		double sec = Double.parseDouble(arg_) / 1000.0;
		return sec; 
	}
	
	public String toString()
	{
		String s = "<break";
//		if ( bargein_ == false ) {
//			s += " bargein=\"false\"";
//		}
		s += ">";
		s += script_;
		s += "</break>";
		return s;
	}
	
}
