/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishimoto [atmark] m.ieice.org)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: EndCommand.java,v 1.3 2009/09/10 08:44:19 nishimoto Exp $
 */

package galatea.command;

import galatea.dialog.RuntimeError;
import galatea.util.Util;

public class EndCommand extends Command
{
	private static void debug(String msg) {
		// System.err.println("EndCommand: " + msg);
	}
	
	boolean now_;
	String next_;
	String post_;
	
	public EndCommand(boolean now)
	{
		now_ = now;
		setCondition("true");
		post_ = "";
	}
	
	public EndCommand(String next)
	{
		next_ = next;
		setCondition("true");
		now_ = false;
		post_ = "";
	}
	
	public EndCommand(String next, String cond, boolean now)
	{
		next_ = next;
		setCondition(cond);
		now_ = now;
		post_ = "";
	}
	
	public EndCommand(String next, String cond, boolean now, String post)
	{
		next_ = next;
		setCondition(cond);
		now_ = now;
		post_ = post;
	}
	
	public EndCommand()
	{
		now_ = false;
	}
	
	public boolean isNow()
	{
		return(now_);
	}
	
	
	public String toString()
	{
		String s = "  <end";
		if ( hasCondition() ) {
			s += " cond=\"" + getConditionAsEncodedString() + "\"";
		}
		s += " now=\"" + now_ +"\"";
		s += " post=\"" + post_ +"\"";
		if ( next_ != null && next_.length() > 0 ) {
			s += ">" + Util.encodeXmlChars(next_) + "</end>";
		} else {
			s += "/>";
		}
		return s;
	}
	
	
	public void execute() throws RuntimeError
	{
		debug("execute..");
		interpreterContext_.setEndFlag(true);
		interpreterContext_.setEndImm(now_);
		if ( next_ != null ) {
			debug("next_ != null..");
			String nf = ecmascript_.evaluate(next_);
			String ps = ecmascript_.evaluate(post_);
			debug("nf=" + nf);
			debug("ps=" + ps);
			interpreterContext_.setNextDocFile(nf, ps);
		}
	}
	
}
