#############################################################

class GalateaBaseThread < GalateaBase
  def initialize
    super
    @modulename = "GalateaBaseThread"
    @mutex = Mutex.new
    @input_queue = Array.new
  end

  attr_accessor :modulename, :debug

  def run
    Thread.start do
      while true
        sleep 0.0001
        while @input_queue.length > 0 do
          cmd = nil
          @mutex.synchronize do
            cmd = @input_queue.delete_at(0)
          end

          # set XXX = xxxx
          if /^\s*set\s+([^\s=]*)\s*=\s*(.*)$/ =~ cmd
            @myslot[$1] = $2
            do_set $1, $2
          end

          # set XXX < filename
          # not implemented

          # prop XXX.attr = xxx
          if /^\s*prop\s+([^\s=]*)\s*=\s*(.*)$/ =~ cmd
            @myprop[$1] = $2
            do_prop $1, $2
          end

          # set XXX << END
          # xxxx
          # END
          # not implemented

          # inq
          if /^\s*inq\s+(.*)$/ =~ cmd
            print_rep "#{$1} = #{@myslot[$1]}"
          end

          # (broadcast only) From @(XXX) (xxxxxxxx)
          if /^\s*From\s+\@(\S+)\s(.*)$/ =~ cmd
            accept_from $1, $2
          end

          # (broadcast only) to @(XXX) (xxxxxxxx)
          if /^\s*to\s+\@(\S+)\s(.*)$/ =~ cmd
            accept_to $1, $2
          end
        end
      end
    end

    while true
      while gets do
        @mutex.synchronize do
          @input_queue.push($_)
        end
        sleep 0.0001
      end
    end

  end

end


