package appengine.util;

import com.google.apphosting.api.ApiProxy;

/**
 * あんまり分類が思いつかないユーティリティメソッドを集めておくユーティリティクラス。
 * @author shin1ogawa
 */
public class AppEngineUtil {

	private static final String LOCAL_HTTP_REQUEST_ENVIRONMENT =
			"com.google.appengine.tools.development.LocalHttpRequestEnvironment";


	private AppEngineUtil() {
	}

	/**
	 * @return デプロイ環境でもなく、ローカルのWebContainer上での実行でも無いなら{@code true}
	 */
	public static boolean isLocalDevelopment() {
		return !isLocalWebDevelopment() && !isDeployment();
	}

	/**
	 * @return ローカルのWebContainer上での環境なら{@code true}
	 */
	public static boolean isLocalWebDevelopment() {
		if (ApiProxy.getCurrentEnvironment() == null) {
			return false;
		}
		String environmentClassName = ApiProxy.getCurrentEnvironment().getClass().getName();
		return LOCAL_HTTP_REQUEST_ENVIRONMENT.equals(environmentClassName);
	}

	/**
	 * @return デプロイ環境なら{@code true}
	 */
	public static boolean isDeployment() {
		if (ApiProxy.getCurrentEnvironment() == null) {
			return false;
		}
		String versionId = ApiProxy.getCurrentEnvironment().getVersionId();
		return versionId.indexOf('.') > 0 && !versionId.endsWith(".1");
	}
}
