package com.shin1ogawa.logic;

import java.io.File;

import org.junit.After;
import org.junit.Before;

import com.google.appengine.api.datastore.dev.LocalDatastoreService;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.appengine.tools.development.StreamHandlerFactory;
import com.google.apphosting.api.ApiProxy;
import com.shin1ogawa.ApiProxyLocalMock;
import com.shin1ogawa.TestEnvironment;

public class AbstractLogicTest {
	private ApiProxyLocalMock apiProxyLocal;

	@Before
	public void setUp() {
		ApiProxy.setEnvironmentForCurrentThread(new TestEnvironment());
		setApiProxyLocal(new ApiProxyLocalMock(new File("target/testAppDir")));
		ApiProxy.setDelegate(getApiProxyLocal());
		ApiProxyLocal proxy = (ApiProxyLocal) ApiProxy.getDelegate();
		proxy.setProperty(LocalDatastoreService.NO_STORAGE_PROPERTY,
				Boolean.TRUE.toString());
		// 単体テスト実行時は、HttpURLConnectionの実装として
		// "sun.net.www.protocol.http.Http[s]URLConnection"
		// が適用されてしまい、ApiProxyはすっ飛ばして動作してしまう。
		// URL.setURLStreamHandlerFactory()する事であっさりすげ替えが可能そうだが、URLStreamHandlerクラスが
		// AppEngineSDKで使用不可の対象なのでエラーマークがついてしまう。
		// そこで、StreamHandlerFactory.install()を実行する事で
		// AppEngine用のURL.setURLStreamHandlerFactory()が内部で実行され、HttpURLConnectionの実装として
		// "com.google.apphosting.utils.security.urlfetch.URLFetchServiceStreamHandler$Connection"
		// を適用させる。こうする事でURLFetchの動作がApiProxyLocal経由で実行されるようになる。
		StreamHandlerFactory.install();
	}

	@After
	public void tearDown() {
		ApiProxy.setDelegate(null);
		ApiProxy.setEnvironmentForCurrentThread(null);
	}

	/**
	 * @param apiProxyLocal
	 *            the apiProxyLocal to set
	 */
	public void setApiProxyLocal(ApiProxyLocalMock apiProxyLocal) {
		this.apiProxyLocal = apiProxyLocal;
	}

	/**
	 * @return the apiProxyLocal
	 */
	public ApiProxyLocalMock getApiProxyLocal() {
		return apiProxyLocal;
	}
}
