package com.shin1ogawa.entity;

import java.io.*;
import java.util.*;

import javax.jdo.annotations.*;

import com.google.appengine.api.datastore.*;
import com.google.appengine.api.datastore.Key;

@SuppressWarnings("serial")
@PersistenceCapable(identityType = IdentityType.APPLICATION, detachable="true")
@Version(strategy = VersionStrategy.VERSION_NUMBER, column = "version")
public class LLParent implements Serializable {
	@PrimaryKey
	@Persistent(valueStrategy = IdGeneratorStrategy.IDENTITY)
	private Key key;

	@Persistent
	private String property1;

	@Persistent(defaultFetchGroup = "true")
	private Text property2;

	@Persistent(defaultFetchGroup = "true")
	private LLChildA childA;

	@Persistent(defaultFetchGroup = "true")
	@Order(extensions = @Extension(vendorName="datanucleus", key="list-ordering", value="property1"))
	private List<LLChildB> childBList;

	/**
	 * @return the key
	 */
	public Key getKey() {
		return key;
	}

	/**
	 * @param key
	 *            the key to set
	 */
	public void setKey(Key key) {
		this.key = key;
	}

	/**
	 * @return the property1
	 */
	public String getProperty1() {
		return property1;
	}

	/**
	 * @param property1
	 *            the property1 to set
	 */
	public void setProperty1(String property1) {
		this.property1 = property1;
	}

	/**
	 * @return the text
	 */
	public Text getProperty2() {
		return property2;
	}

	/**
	 * @param text
	 *            the text to set
	 */
	public void setProperty2(Text text) {
		this.property2 = text;
	}

	/**
	 * @return the childA
	 */
	public LLChildA getChildA() {
		return childA;
	}

	/**
	 * @param childA
	 *            the childA to set
	 */
	public void setChildA(LLChildA childA) {
		this.childA = childA;
	}

	/**
	 * @return the childBList
	 */
	public List<LLChildB> getChildBList() {
		return childBList;
	}

	/**
	 * @param childBList
	 *            the childBList to set
	 */
	public void setChildBList(List<LLChildB> childBList) {
		this.childBList = childBList;
	}
}
