package sample.entity;

import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManagerFactory;

/**
 * {@link PersistenceManagerFactory}を管理するためのクラス。
 * @author shin1ogawa
 */
public final class PMF {

	private static final PersistenceManagerFactory pmfInstance =
			JDOHelper.getPersistenceManagerFactory("transactions-optional");


	private PMF() {
	}

	/**
	 * @return {@link PersistenceManagerFactory}
	 */
	public static PersistenceManagerFactory get() {
		return pmfInstance;
	}
}
