/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.util.MapWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NamedAttrNodeMapImpl
extends MapWrapper<String, DomAttr>
implements NamedNodeMap,
Serializable {
    private static final long serialVersionUID = -450637965125944616L;
    private final List<String> attrPositions_ = new ArrayList<String>();
    private final DomElement domNode_;
    public static final NamedAttrNodeMapImpl EMPTY_MAP = new NamedAttrNodeMapImpl();
    private final boolean caseSensitive_;

    private NamedAttrNodeMapImpl() {
        super(Collections.emptyMap());
        this.domNode_ = null;
        this.caseSensitive_ = true;
    }

    NamedAttrNodeMapImpl(DomElement domNode, boolean caseSensitive, Map<String, DomAttr> attributes) {
        super(attributes);
        if (domNode == null) {
            throw new IllegalArgumentException();
        }
        this.domNode_ = domNode;
        this.caseSensitive_ = caseSensitive;
        for (String name : this.keySet()) {
            this.attrPositions_.add(name);
        }
    }

    NamedAttrNodeMapImpl(DomElement domElement, boolean caseSensitive) {
        this(domElement, caseSensitive, new HashMap<String, DomAttr>());
    }

    @Override
    public int getLength() {
        return this.size();
    }

    @Override
    public DomAttr getNamedItem(String name) {
        return this.get(this.fixName(name));
    }

    private String fixName(String name) {
        if (this.caseSensitive_) {
            return name;
        }
        return name.toLowerCase();
    }

    @Override
    public Node getNamedItemNS(String namespaceURI, String localName) {
        if (this.domNode_ == null) {
            return null;
        }
        return this.get(this.domNode_.getQualifiedName(namespaceURI, this.fixName(localName)));
    }

    @Override
    public Node item(int index) {
        if (index < 0 || index >= this.attrPositions_.size()) {
            return null;
        }
        return this.get(this.attrPositions_.get(index));
    }

    @Override
    public Node removeNamedItem(String name) throws DOMException {
        return this.remove(this.fixName(name));
    }

    @Override
    public Node removeNamedItemNS(String namespaceURI, String localName) {
        if (this.domNode_ == null) {
            return null;
        }
        return this.remove(this.domNode_.getQualifiedName(namespaceURI, this.fixName(localName)));
    }

    @Override
    public DomAttr setNamedItem(Node node) {
        return this.put(this.fixName(node.getLocalName()), (DomAttr)node);
    }

    @Override
    public Node setNamedItemNS(Node node) throws DOMException {
        return this.put(this.fixName(node.getNodeName()), (DomAttr)node);
    }

    @Override
    public DomAttr put(String key, DomAttr value) {
        if (!this.containsKey(key = this.fixName(key))) {
            this.attrPositions_.add(key);
        }
        return super.put(key, value);
    }

    @Override
    public DomAttr remove(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        String name = this.fixName((String)key);
        this.attrPositions_.remove(name);
        return (DomAttr)super.remove(name);
    }

    @Override
    public void clear() {
        this.attrPositions_.clear();
        super.clear();
    }

    @Override
    public void putAll(Map<? extends String, ? extends DomAttr> t) {
        for (Map.Entry<? extends String, ? extends DomAttr> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean containsKey(Object key) {
        if (!(key instanceof String)) {
            return false;
        }
        String name = this.fixName((String)key);
        return super.containsKey(name);
    }

    @Override
    public DomAttr get(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        String name = this.fixName((String)key);
        return (DomAttr)super.get(name);
    }
}

