/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.util;

import java.net.URI;
import java.util.Map;
import org.t2framework.commons.util.ArrayUtil;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.commons.util.ConverterUtil;

public class UrlBuilder {
    protected String base;
    protected final Map<String, Object> urlParameters = CollectionsUtil.newHashMap();

    public UrlBuilder() {
    }

    public UrlBuilder(String base) {
        this.base = Assertion.notNull(base);
    }

    public void setBase(String base) {
        this.base = Assertion.notNull(base);
    }

    public String build() {
        StringBuilder sb = new StringBuilder(100);
        URI uri = URI.create(this.base);
        if (uri.getScheme() != null) {
            sb.append(uri.getScheme());
            sb.append(":");
        }
        if (uri.getAuthority() != null) {
            sb.append("//");
            sb.append(uri.getAuthority());
        }
        if (uri.getPath() != null) {
            sb.append(uri.getPath());
        } else if (uri.getSchemeSpecificPart() != null) {
            sb.append(uri.getSchemeSpecificPart());
        }
        boolean questionAppeared = false;
        if (uri.getQuery() != null) {
            questionAppeared = true;
            sb.append('?');
            sb.append(uri.getQuery());
        }
        for (String key : this.urlParameters.keySet()) {
            Object[] values;
            Object value = this.urlParameters.get(key);
            if (value == null) continue;
            if (!value.getClass().isArray()) {
                if (questionAppeared) {
                    sb.append('&');
                } else {
                    sb.append('?');
                    questionAppeared = true;
                }
                this.appenQueryString(key, value, sb, questionAppeared);
                continue;
            }
            for (Object v : values = (Object[])value) {
                if (questionAppeared) {
                    sb.append('&');
                } else {
                    sb.append('?');
                    questionAppeared = true;
                }
                this.appenQueryString(key, v, sb, questionAppeared);
            }
        }
        if (uri.getFragment() != null) {
            sb.append('#');
            sb.append(uri.getFragment());
        }
        return new String(sb);
    }

    protected void appenQueryString(String key, Object v, StringBuilder sb, boolean questionAppeared) {
        sb.append(key);
        sb.append('=');
        sb.append(ConverterUtil.convertAsString(v));
    }

    public void add(String key, Object value) {
        Assertion.notNulls(key, value);
        if (this.urlParameters.containsKey(key)) {
            Object o = this.urlParameters.get(key);
            if (o == null) {
                this.urlParameters.put(key, value);
            } else if (o.getClass().isArray()) {
                ArrayUtil.add((Object[])o, value);
            } else {
                Object[] array = new Object[]{o, value};
                this.urlParameters.put(key, array);
            }
        } else {
            this.urlParameters.put(key, value);
        }
    }

    public String getBase() {
        return this.base;
    }

    public Map<String, Object> getUrlParameters() {
        return this.urlParameters;
    }

    public void addAll(Map<String, Object> params) {
        this.urlParameters.putAll(params);
    }
}

