/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.t2framework.commons.exception.IORuntimeException;
import org.t2framework.commons.exception.MalformedURLRuntimeException;
import org.t2framework.commons.util.Assertion;

public class URLUtil {
    protected static final Map<String, String> CANONICAL_PROTOCOLS = new HashMap<String, String>();
    protected static final String VALID_SCHEME_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+.-";

    private URLUtil() {
    }

    public static URLConnection openConnection(URL url) {
        try {
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            return connection;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static InputStream openStream(URL url) {
        try {
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            return connection.getInputStream();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static URL create(String spec) {
        try {
            return new URL(spec);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static URL create(URL context, String spec) {
        try {
            return new URL(context, spec);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static String encode(String s, String enc) {
        try {
            return URLEncoder.encode(s, enc);
        }
        catch (UnsupportedEncodingException e) {
            throw new IORuntimeException(e);
        }
    }

    public static String decode(String s, String enc) {
        try {
            return URLDecoder.decode(s, enc);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toCanonicalProtocol(String protocol) {
        String canonicalProtocol = CANONICAL_PROTOCOLS.get(protocol);
        if (canonicalProtocol != null) {
            return canonicalProtocol;
        }
        return protocol;
    }

    public static boolean isAbsoluteUrl(String url) {
        if (url == null) {
            return false;
        }
        int colonPos = url.indexOf(":");
        if (colonPos == -1) {
            return false;
        }
        for (int i = 0; i < colonPos; ++i) {
            if (VALID_SCHEME_CHARS.indexOf(url.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    public static URL toUrl(File file) {
        Assertion.notNull(file);
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new MalformedURLRuntimeException(e);
        }
    }

    static {
        CANONICAL_PROTOCOLS.put("wsjar", "jar");
        CANONICAL_PROTOCOLS.put("vfszip", "zip");
    }
}

