/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.util;

import java.util.List;
import java.util.StringTokenizer;
import org.t2framework.commons.Constants;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;

public final class StringUtil {
    protected StringUtil() {
    }

    public static boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }

    public static boolean isAllEmpty(String[] regexes) {
        if (regexes == null) {
            return false;
        }
        for (String regex : regexes) {
            if (StringUtil.isEmpty(regex)) continue;
            return false;
        }
        return true;
    }

    public static String replace(String text, String fromText, String toText) {
        if (Assertion.hasNull(text, fromText, toText)) {
            return text;
        }
        if (StringUtil.isEmpty(fromText) && StringUtil.isEmpty(toText)) {
            return text;
        }
        StringBuilder buf = new StringBuilder(100);
        int from = 0;
        int to = 0;
        while (true) {
            if ((to = text.indexOf(fromText, from)) == 0) {
                buf.append(toText);
                from = fromText.length();
                continue;
            }
            if (to <= 0) break;
            buf.append(text.substring(from, to));
            buf.append(toText);
            from = to + fromText.length();
        }
        buf.append(text.substring(from));
        return buf.toString();
    }

    public static String[] split(String str, String delim) {
        if (StringUtil.isEmpty(str)) {
            return Constants.EMPTY_STRING_ARRAY;
        }
        List<String> list = CollectionsUtil.newArrayList();
        StringTokenizer st = new StringTokenizer(str, delim);
        while (st.hasMoreElements()) {
            list.add((String)st.nextElement());
        }
        return list.toArray(new String[list.size()]);
    }

    public static final String leftTrim(String text) {
        return StringUtil.leftTrim(text, null);
    }

    public static final String leftTrim(String text, String trimText) {
        int pos;
        if (text == null) {
            return null;
        }
        if (trimText == null) {
            trimText = " ";
        }
        for (pos = 0; pos < text.length() && trimText.indexOf(text.charAt(pos)) >= 0; ++pos) {
        }
        return text.substring(pos);
    }

    public static final String rightTrim(String text) {
        return StringUtil.rightTrim(text, null);
    }

    public static final String rightTrim(String text, String trimText) {
        int pos;
        if (text == null) {
            return null;
        }
        if (trimText == null) {
            trimText = " ";
        }
        for (pos = text.length() - 1; pos >= 0 && trimText.indexOf(text.charAt(pos)) >= 0; --pos) {
        }
        return text.substring(0, pos + 1);
    }

    public static final String trimSuffix(String text, String suffix) {
        if (text == null) {
            return null;
        }
        if (suffix == null) {
            return text;
        }
        if (text.endsWith(suffix)) {
            return text.substring(0, text.length() - suffix.length());
        }
        return text;
    }

    public static final String trimPrefix(String text, String prefix) {
        if (text == null) {
            return null;
        }
        if (prefix == null) {
            return text;
        }
        if (text.startsWith(prefix)) {
            return text.substring(prefix.length());
        }
        return text;
    }

    public static String decapitalize(String name) {
        if (StringUtil.isEmpty(name)) {
            return name;
        }
        char[] chars = name.toCharArray();
        if (chars.length >= 2 && Character.isUpperCase(chars[0]) && Character.isUpperCase(chars[1])) {
            return name;
        }
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static String capitalize(String name) {
        if (StringUtil.isEmpty(name)) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static boolean startsWith(String text, String fragment) {
        return StringUtil.startsWithIgnoreCase(text, fragment);
    }

    public static boolean isBlank(String str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !StringUtil.isBlank(str);
    }

    public static boolean contains(String str, char ch) {
        if (StringUtil.isEmpty(str)) {
            return false;
        }
        return str.indexOf(ch) >= 0;
    }

    public static boolean contains(String s1, String s2) {
        if (StringUtil.isEmpty(s1)) {
            return false;
        }
        return s1.indexOf(s2) >= 0;
    }

    public static boolean equals(String target1, String target2) {
        return target1 == null ? target2 == null : target1.equals(target2);
    }

    public static boolean equalsIgnoreCase(String target1, String target2) {
        return target1 == null ? target2 == null : target1.equalsIgnoreCase(target2);
    }

    public static boolean endsWithIgnoreCase(String target1, String target2) {
        int length2;
        if (target1 == null || target2 == null) {
            return false;
        }
        int length1 = target1.length();
        if (length1 < (length2 = target2.length())) {
            return false;
        }
        String s1 = target1.substring(length1 - length2);
        return s1.equalsIgnoreCase(target2);
    }

    public static boolean startsWithIgnoreCase(String target1, String target2) {
        int length2;
        if (target1 == null || target2 == null) {
            return false;
        }
        int length1 = target1.length();
        if (length1 < (length2 = target2.length())) {
            return false;
        }
        String s1 = target1.substring(0, target2.length());
        return s1.equalsIgnoreCase(target2);
    }

    public static String substringFromLast(String str, String separator) {
        if (StringUtil.isEmpty(str) || StringUtil.isEmpty(separator)) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String substringToLast(String str, String separator) {
        if (StringUtil.isEmpty(str) || StringUtil.isEmpty(separator)) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(pos + 1, str.length());
    }

    public static String toHex(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            StringUtil.appendHex(sb, bytes[i]);
        }
        return sb.toString();
    }

    public static String toHex(int i) {
        StringBuffer buf = new StringBuffer();
        StringUtil.appendHex(buf, i);
        return buf.toString();
    }

    public static void appendHex(StringBuffer buf, byte i) {
        buf.append(Character.forDigit((i & 0xF0) >> 4, 16));
        buf.append(Character.forDigit(i & 0xF, 16));
    }

    public static void appendHex(StringBuffer buf, int i) {
        buf.append(Integer.toHexString(i >> 24 & 0xFF));
        buf.append(Integer.toHexString(i >> 16 & 0xFF));
        buf.append(Integer.toHexString(i >> 8 & 0xFF));
        buf.append(Integer.toHexString(i & 0xFF));
    }

    public static int counts(String str, char target) {
        Assertion.notNull(str);
        int ret = 0;
        for (int i = 0; i < str.length(); ++i) {
            char charAt = str.charAt(i);
            if (charAt != target) continue;
            ++ret;
        }
        return ret;
    }

    public static Integer[] getPosition(String str, char target) {
        Assertion.notNull(str);
        List<Integer> retList = CollectionsUtil.newArrayList();
        for (int i = 0; i < str.length(); ++i) {
            char charAt = str.charAt(i);
            if (charAt != target) continue;
            retList.add(i);
        }
        return retList.toArray(new Integer[0]);
    }

    public static String toString(Object o) {
        return StringUtil.toString(o, "");
    }

    public static String toString(Object o, String defaultValue) {
        return o == null ? defaultValue : o.toString();
    }
}

