/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.util;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceBundleUtil {
    public static ResourceBundle getBundle(String bundleName) {
        return ResourceBundleUtil.getBundle(bundleName, Locale.getDefault(), Thread.currentThread().getContextClassLoader());
    }

    public static ResourceBundle getBundle(String bundleName, ClassLoader loader) {
        return ResourceBundleUtil.getBundle(bundleName, Locale.getDefault(), loader);
    }

    public static ResourceBundle getBundle(String bundleName, Locale locale) {
        return ResourceBundleUtil.getBundle(bundleName, locale, Thread.currentThread().getContextClassLoader());
    }

    public static ResourceBundle getBundle(String bundleName, Locale locale, ClassLoader loader) {
        try {
            return ResourceBundle.getBundle(bundleName, locale, loader);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public static ResourceBundle getBundleNoCache(String bundleName) {
        return ResourceBundleUtil.getBundleNoCache(bundleName, Locale.getDefault(), Thread.currentThread().getContextClassLoader());
    }

    public static ResourceBundle getBundleNoCache(String bundleName, ClassLoader loader) {
        return ResourceBundleUtil.getBundleNoCache(bundleName, Locale.getDefault(), loader);
    }

    public static ResourceBundle getBundleNoCache(String bundleName, Locale locale) {
        return ResourceBundleUtil.getBundleNoCache(bundleName, locale, Thread.currentThread().getContextClassLoader());
    }

    public static ResourceBundle getBundleNoCache(String bundleName, Locale locale, ClassLoader loader) {
        try {
            return ResourceBundle.getBundle(bundleName, locale, loader, new ResourceBundle.Control(){

                @Override
                public long getTimeToLive(String baseName, Locale locale) {
                    return -1L;
                }
            });
        }
        catch (MissingResourceException e) {
            return null;
        }
    }
}

