/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.util;

import org.t2framework.commons.util.StringUtil;

public class ContentTypeUtil {
    public static String getContentType(String contentType) {
        int i;
        if (contentType == null) {
            return "text/html";
        }
        String[] strs = StringUtil.split(contentType, ",");
        String[] contentTypes = ContentTypeUtil.removeSemiColon(strs);
        for (i = 0; i < contentTypes.length; ++i) {
            if (!ContentTypeUtil.isHtmlContentType(contentTypes[i].trim())) continue;
            return "text/html";
        }
        for (i = 0; i < contentTypes.length; ++i) {
            if (!ContentTypeUtil.isXmlContentType(contentTypes[i].trim())) continue;
            return "application/xhtml+xml";
        }
        return "text/html";
    }

    protected static String[] removeSemiColon(String[] contentTypes) {
        for (int i = 0; i < contentTypes.length; ++i) {
            String type = contentTypes[i];
            int index = type.indexOf(";");
            if (index == -1) continue;
            contentTypes[i] = type = type.substring(0, index);
        }
        return contentTypes;
    }

    public static boolean isHtmlContentType(String type) {
        return type.indexOf("text/html") != -1 || type.equals("*/*");
    }

    public static boolean isXmlContentType(String type) {
        return type.indexOf("application/xhtml+xml") != -1 || type.indexOf("application/xml") != -1 || type.indexOf("text/xml") != -1;
    }

    public static String getEncodingFromContentType(String contentType) {
        String sub;
        int semi;
        if (contentType == null) {
            return null;
        }
        if (contentType != null && (semi = contentType.indexOf(59)) >= 0 && (sub = contentType.substring(semi + 1).trim()).toLowerCase().startsWith("charset=")) {
            return sub.substring("charset=".length()).trim();
        }
        return null;
    }
}

