/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.meta.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import org.t2framework.commons.Constants;
import org.t2framework.commons.exception.IllegalPropertyRuntimeException;
import org.t2framework.commons.exception.NoSuchGetterMethodRuntimeException;
import org.t2framework.commons.exception.NoSuchSetterMethodRuntimeException;
import org.t2framework.commons.meta.ClassDesc;
import org.t2framework.commons.meta.MethodDesc;
import org.t2framework.commons.meta.PropertyDesc;
import org.t2framework.commons.meta.impl.AbstractConfigContainer;
import org.t2framework.commons.meta.impl.MethodDescImpl;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.AutoboxingUtil;
import org.t2framework.commons.util.ConverterUtil;
import org.t2framework.commons.util.JavaBeansUtil;
import org.t2framework.commons.util.Reflections;

public class PropertyDescImpl<T>
extends AbstractConfigContainer
implements PropertyDesc<T> {
    protected MethodDesc readMethodDesc;
    protected MethodDesc writeMethodDesc;
    protected String propertyName;
    protected Class<?> propertyType;
    protected Class<T> targetClass;
    protected Field field;
    protected boolean array;
    protected Class<?> componentType;

    public PropertyDescImpl(ClassDesc<T> classDesc, Class<?> propertyType, String propertyName) {
        this(classDesc, propertyType, propertyName, false);
    }

    public PropertyDescImpl(ClassDesc<T> classDesc, Class<?> propertyType, String propertyName, boolean findAuto) {
        this(classDesc.getConcreteClass(), propertyType, propertyName, findAuto);
    }

    public PropertyDescImpl(Class<T> targetClass, Class<?> propertyType, String propertyName) {
        this(targetClass, propertyType, propertyName, false);
    }

    public PropertyDescImpl(Class<T> targetClass, Class<?> propertyType, String propertyName, boolean findAuto) {
        this.propertyType = Assertion.notNull(propertyType);
        this.propertyName = Assertion.notNull(propertyName);
        this.targetClass = targetClass;
        this.array = propertyType.isArray();
        if (this.array) {
            this.componentType = propertyType.getComponentType();
        }
        this.init(findAuto);
    }

    protected void init(boolean findAuto) {
        if (this.targetClass == null) {
            return;
        }
        this.field = Reflections.FieldUtil.getFieldWithAccessibleNoException(this.targetClass, this.propertyName);
        if (this.field == null) {
            return;
        }
        this.getConfigSupport().addAllAnnotationConfig(this.field);
        if (findAuto) {
            this.findReadWriteMethod(this.field);
        }
    }

    protected void findReadWriteMethod(Field field) {
        String fieldName = field.getName();
        Class<?> type = field.getType();
        String readMethodPrefix = "get";
        if (type == Boolean.TYPE || type == Boolean.class) {
            readMethodPrefix = "is";
        }
        String readMethodName = readMethodPrefix + JavaBeansUtil.capitalize(fieldName);
        String writeMethodName = "set" + JavaBeansUtil.capitalize(fieldName);
        try {
            Method rm = Reflections.MethodUtil.getDeclaredMethod(this.getTargetClass(), readMethodName, Constants.EMPTY_CLASS_ARRAY);
            this.setReadMethod(rm);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            Method wm = Reflections.MethodUtil.getDeclaredMethod(this.getTargetClass(), writeMethodName, new Class[]{type});
            this.setWriteMethod(wm);
        }
        catch (Exception ignore) {
            // empty catch block
        }
    }

    @Override
    public void setReadMethod(Method readMethod) {
        Assertion.notNull(readMethod);
        this.readMethodDesc = new MethodDescImpl(readMethod);
        this.support.addAllAnnotationConfig(readMethod);
    }

    @Override
    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public void setWriteMethod(Method writeMethod) {
        Assertion.notNull(writeMethod);
        this.writeMethodDesc = new MethodDescImpl(writeMethod);
        this.support.addAllAnnotationConfig(writeMethod);
    }

    @Override
    public void setPropertyType(Class<?> propertyType) {
        this.propertyType = propertyType;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    @Override
    public Method getReadMethod() {
        this.assertReadMethodDesc();
        return this.readMethodDesc.getMethod();
    }

    @Override
    public Method getWriteMethod() {
        this.assertWriteMethodDesc();
        return this.writeMethodDesc.getMethod();
    }

    @Override
    public Object getValue(T target) {
        this.assertReadMethodDesc();
        return this.readMethodDesc.invoke(target, Constants.EMPTY_ARRAY);
    }

    @Override
    public void setValue(T target, Object value) {
        this.assertWriteMethodDesc();
        try {
            this.writeMethodDesc.invoke(target, this.convertArgs(value));
        }
        catch (Throwable t) {
            throw new IllegalPropertyRuntimeException(t, this.targetClass, this.propertyName);
        }
    }

    protected Object[] convertArgs(Object value) {
        Object[] convertedArgs = null;
        if (value == null || Assertion.isAllNull(value)) {
            convertedArgs = this.convertNullToPrimitiveValueArgs(this.writeMethodDesc);
        } else {
            Class<?> clazz = value.getClass();
            if (clazz.isArray()) {
                Class<?> type = clazz.getComponentType();
                convertedArgs = new Object[]{this.convertArray(value, type.isPrimitive())};
            } else {
                convertedArgs = new Object[]{this.convert0(value)};
            }
        }
        return convertedArgs;
    }

    protected Object convertArray(Object args, boolean primitive) {
        if (!this.isArray() || this.componentType == null) {
            throw new IllegalStateException("convertArray must not work without componentType.");
        }
        boolean isNotPrimitive = !primitive;
        Object[] array = isNotPrimitive ? (Object[])args : null;
        int length = isNotPrimitive ? array.length : Array.getLength(args);
        Object ret = Array.newInstance(this.componentType, length);
        for (int i = 0; i < length; ++i) {
            Object o;
            Object object = o = isNotPrimitive ? array[i] : Array.get(args, i);
            if (o == null) continue;
            Class<?> clazz = o.getClass();
            if (clazz.isArray()) {
                Class<?> type = clazz.getComponentType();
                Array.set(ret, i, this.convertArray(o, type.isPrimitive()));
                continue;
            }
            Array.set(ret, i, this.convert0(o));
        }
        return ret;
    }

    protected Object convert0(Object o) {
        Class<?> c = !this.isArray() ? this.propertyType : this.componentType;
        if (c.isPrimitive()) {
            return ConverterUtil.convert(o, c);
        }
        if (Number.class.isAssignableFrom(c)) {
            return ConverterUtil.convert(o, c);
        }
        if (Date.class.isAssignableFrom(c)) {
            return ConverterUtil.convertAsDate(o);
        }
        if (Boolean.class == c) {
            return ConverterUtil.convertAsBoolean(o);
        }
        if (Calendar.class.isAssignableFrom(c)) {
            return ConverterUtil.convertAsCalendar(o);
        }
        if (String.class.isAssignableFrom(c)) {
            return ConverterUtil.convertAsString(o);
        }
        return o;
    }

    protected Object[] convertNullToPrimitiveValueArgs(MethodDesc wmd) {
        Class<?>[] paramTypes = wmd.getParameterTypes();
        int len = paramTypes.length;
        Object[] ret = new Object[len];
        for (int i = 0; i < len; ++i) {
            Class<?> c = paramTypes[i];
            ret[i] = c.isPrimitive() ? AutoboxingUtil.getDefaultPrimitiveValue(c) : null;
        }
        return ret;
    }

    protected void assertWriteMethodDesc() {
        if (!this.isWritable()) {
            throw new NoSuchSetterMethodRuntimeException(this.targetClass, this.propertyName);
        }
    }

    protected void assertReadMethodDesc() {
        if (!this.isReadable()) {
            throw new NoSuchGetterMethodRuntimeException(this.targetClass, this.propertyName, this.propertyType);
        }
    }

    @Override
    public boolean isReadable() {
        return this.readMethodDesc != null;
    }

    @Override
    public boolean isWritable() {
        return this.writeMethodDesc != null;
    }

    @Override
    public MethodDesc getReadMethodDesc() {
        this.assertReadMethodDesc();
        return this.readMethodDesc;
    }

    @Override
    public MethodDesc getWriteMethodDesc() {
        this.assertWriteMethodDesc();
        return this.writeMethodDesc;
    }

    @Override
    public void setReadMethodDesc(MethodDesc readMethodDesc) {
        this.readMethodDesc = Assertion.notNull(readMethodDesc);
        this.support.addAllAnnotationConfig(readMethodDesc.getMethod());
    }

    @Override
    public void setWriteMethodDesc(MethodDesc writeMethodDesc) {
        this.writeMethodDesc = Assertion.notNull(writeMethodDesc);
        this.support.addAllAnnotationConfig(writeMethodDesc.getMethod());
    }

    @Override
    public Class<T> getTargetClass() {
        return this.targetClass;
    }

    protected boolean isArray() {
        return this.array;
    }

    protected void setArray(boolean array) {
        this.array = array;
    }
}

