/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.meta.impl;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.t2framework.commons.Constants;
import org.t2framework.commons.annotation.Lookup;
import org.t2framework.commons.meta.AnnotationConfig;
import org.t2framework.commons.meta.ConfigContainer;
import org.t2framework.commons.meta.ConfigType;
import org.t2framework.commons.meta.LookupContext;
import org.t2framework.commons.meta.spi.AnnotationConfigSupport;
import org.t2framework.commons.module.Modules;
import org.t2framework.commons.util.AnnotationUtil;
import org.t2framework.commons.util.ArrayUtil;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.CollectionsUtil;
import org.t2framework.commons.util.Reflections;
import org.t2framework.commons.util.StringUtil;

public class AnnotationConfigImpl
implements AnnotationConfig {
    protected Annotation annotation;
    protected ElementType type;
    protected String annotationName;
    protected List<Annotation> metaAnnotationList;
    protected Class<? extends Annotation> annotationType;
    protected ElementType[] acceptableElementTypes;
    protected ConfigContainer container;
    protected List<String> methodNameList = CollectionsUtil.newArrayList();
    protected Map<Class<? extends Annotation>, LookupContext> lookupContextMap = CollectionsUtil.newHashMap();

    public AnnotationConfigImpl(Annotation annotation) {
        this(annotation, null);
    }

    public AnnotationConfigImpl(Annotation annotation, ElementType type) {
        this(annotation, type, null);
    }

    public AnnotationConfigImpl(Annotation annotation, ElementType type, ConfigContainer container) {
        this.annotation = Assertion.notNull(annotation);
        this.type = type;
        this.metaAnnotationList = CollectionsUtil.newArrayList();
        this.container = container;
        this.initAnnotationInfo(annotation);
        this.initMetaAnnotationList(this.annotationType);
        this.initLookupMethodMap(this.annotationType);
    }

    protected void initAnnotationInfo(Annotation annotation) {
        this.annotationName = annotation.annotationType().getSimpleName();
        this.annotationType = annotation.annotationType();
    }

    protected void initMetaAnnotationList(Class<? extends Annotation> annotationType) {
        for (Annotation a : annotationType.getAnnotations()) {
            if (!AnnotationUtil.isJavaLangAnnotation(a)) {
                this.metaAnnotationList.add(a);
            }
            if (!AnnotationUtil.isTargetAnnotation(a)) continue;
            Target t = (Target)Target.class.cast(a);
            this.acceptableElementTypes = t.value();
            this.assertAcceptableElementType();
        }
    }

    protected void initLookupMethodMap(Class<? extends Annotation> annotationType) {
        for (Method m : annotationType.getDeclaredMethods()) {
            for (Annotation a : m.getDeclaredAnnotations()) {
                if (a.annotationType() != Lookup.class) continue;
                Lookup lookup = (Lookup)Lookup.class.cast(a);
                Class<? extends Annotation> key = lookup.value();
                LookupContext context = null;
                context = !this.lookupContextMap.containsKey(key) ? new LookupContext(key) : this.lookupContextMap.get(key);
                String alias = lookup.alias();
                if (StringUtil.isEmpty(alias)) {
                    alias = m.getName();
                }
                context.addMethodValue(alias, Reflections.MethodUtil.invoke(m, this.annotation, Constants.EMPTY_ARRAY));
                this.lookupContextMap.put(key, context);
            }
            this.methodNameList.add(m.getName());
        }
    }

    protected void assertAcceptableElementType() {
        if (this.acceptableElementTypes == null) {
            return;
        }
        if (this.type != null && !ArrayUtil.contains(this.acceptableElementTypes, this.type)) {
            throw new IllegalStateException("ElementType should be in @Target' element types.");
        }
    }

    @Override
    public ElementType getElementType() {
        return this.type;
    }

    @Override
    public List<Annotation> getMetaAnnotationList() {
        return this.metaAnnotationList;
    }

    @Override
    public void setElementType(ElementType type) {
        this.type = type;
        this.assertAcceptableElementType();
    }

    @Override
    public ElementType[] getAcceptableTypes() {
        return this.acceptableElementTypes;
    }

    @Override
    public boolean isAcceptableType(ElementType type) {
        Assertion.notNull(type);
        return ArrayUtil.contains(this.getAcceptableTypes(), type);
    }

    @Override
    public Annotation getAnnotation() {
        return this.annotation;
    }

    public Class<? extends Annotation> getType() {
        return this.annotationType;
    }

    @Override
    public ConfigType getConfigType() {
        return ConfigType.ANNOTATION;
    }

    @Override
    public boolean hasAnnotation() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(String methodName, Object value) {
        Assertion.notNull(methodName);
        Assertion.notNull(value);
        Annotation annotation = this.annotation;
        synchronized (annotation) {
            AnnotationConfigSupport annotationConfigSupport = Modules.getService(AnnotationConfigSupport.class);
            if (annotationConfigSupport != null) {
                this.annotation = annotationConfigSupport.createAnnotation(this.annotation, methodName, value);
                this.initAnnotationInfo(this.annotation);
            }
        }
    }

    @Override
    public boolean hasLookup(Class<? extends Annotation> annotationClass) {
        Assertion.notNull(annotationClass);
        return this.lookupContextMap.containsKey(annotationClass);
    }

    @Override
    public LookupContext getLookupContext(Class<? extends Annotation> annotationClass) {
        Assertion.notNull(annotationClass);
        return this.lookupContextMap.get(annotationClass);
    }

    @Override
    public void setValues(LookupContext lookupContext) {
        Assertion.notNull(lookupContext);
        for (String methodName : this.methodNameList) {
            if (!lookupContext.contains(methodName)) continue;
            Object value = lookupContext.getValue(methodName);
            this.setValue(methodName, value);
        }
    }

    @Override
    public ConfigContainer getConfigContainer() {
        return this.container;
    }
}

