/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.commons.cache;

import org.t2framework.commons.cache.Cache;
import org.t2framework.commons.cache.CacheSynchronization;
import org.t2framework.commons.cache.CacheType;
import org.t2framework.commons.cache.impl.LRUCache;
import org.t2framework.commons.cache.impl.NoneCache;
import org.t2framework.commons.cache.impl.SimpleCache;
import org.t2framework.commons.cache.impl.WeakReferenceCache;
import org.t2framework.commons.util.Assertion;

public class CacheFactory {
    public static <K, V> Cache<K, V> createCache(CacheType type) {
        return CacheFactory.createCache(type, CacheSynchronization.NONE, 16, 32);
    }

    public static <K, V> Cache<K, V> createCache(CacheType type, CacheSynchronization sync) {
        return CacheFactory.createCache(type, sync, 16, 32);
    }

    public static <K, V> Cache<K, V> createCache(CacheType type, int initialCapacity) {
        return CacheFactory.createCache(type, CacheSynchronization.NONE, initialCapacity, 32);
    }

    public static <K, V> Cache<K, V> createCache(CacheType type, CacheSynchronization sync, int initialCapacity) {
        return CacheFactory.createCache(type, sync, initialCapacity, 32);
    }

    public static <K, V> Cache<K, V> createCache(CacheType type, int initialCapacity, int limitSize) {
        return CacheFactory.createCache(type, CacheSynchronization.NONE, initialCapacity, 32);
    }

    public static <K, V> Cache<K, V> createCache(CacheType type, CacheSynchronization sync, int initialCapacity, int limitSize) {
        Assertion.notNull(type);
        Assertion.notNull(sync);
        if (type == CacheType.DEFAULT) {
            return new SimpleCache(sync, initialCapacity);
        }
        if (type == CacheType.WEAK) {
            return new WeakReferenceCache(sync, initialCapacity);
        }
        if (type == CacheType.LRU) {
            return new LRUCache(sync, initialCapacity, limitSize);
        }
        return NoneCache.INSTANCE;
    }
}

