/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.store.exceptions.NotYetFlushedException;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.ObjectExpression;
import org.datanucleus.store.mapped.expression.ObjectLiteral;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.SingleFieldMapping;
import org.datanucleus.util.NucleusLogger;

public class OIDMapping
extends SingleFieldMapping {
    public void setObject(ObjectManager om, Object ps, int[] param, Object value) {
        if (value == null) {
            this.getDataStoreMapping(0).setObject(ps, param[0], null);
        } else {
            OID oid;
            ApiAdapter api = om.getApiAdapter();
            if (api.isPersistable(value)) {
                oid = (OID)api.getIdForObject(value);
                if (oid == null) {
                    if (om.isInserting(value)) {
                        this.getDataStoreMapping(0).setObject(ps, param[0], null);
                        throw new NotYetFlushedException(value);
                    }
                    om.persistObjectInternal(value, null, null, -1, 0);
                    om.flushInternal(false);
                }
                oid = (OID)api.getIdForObject(value);
            } else {
                oid = (OID)value;
            }
            try {
                this.getDataStoreMapping(0).setObject(ps, param[0], oid.getKeyValue());
            }
            catch (Exception e) {
                this.getDataStoreMapping(0).setObject(ps, param[0], oid.getKeyValue().toString());
            }
        }
    }

    public Object getObject(ObjectManager om, Object rs, int[] param) {
        Object value;
        if (this.getNumberOfDatastoreFields() > 0) {
            value = this.getDataStoreMapping(0).getObject(rs, param[0]);
        } else {
            if (this.referenceMapping != null) {
                return this.referenceMapping.getObject(om, rs, param);
            }
            MappedStoreManager storeMgr = (MappedStoreManager)om.getStoreManager();
            Class fieldType = this.mmd.getType();
            JavaTypeMapping referenceMapping = storeMgr.getDatastoreClass(fieldType.getName(), om.getClassLoaderResolver()).getIDMapping();
            value = referenceMapping.getDataStoreMapping(0).getObject(rs, param[0]);
        }
        if (value != null) {
            value = OIDFactory.getInstance(om, this.getType(), value);
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("041034", value));
            }
        } else {
            NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("041035"));
        }
        return value;
    }

    public Object getSampleValue(ClassLoaderResolver clr) {
        return "NO SAMPLE AVAILABLE";
    }

    public Class getJavaType() {
        return OID.class;
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        return new ObjectLiteral(qs, this, value, this.getType());
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        return new ObjectExpression(qs, this, te);
    }
}

