/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.plugin.impl;

import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.t2framework.commons.meta.MethodDesc;
import org.t2framework.commons.util.Assertion;
import org.t2framework.t2.action.ActionContext;
import org.t2framework.t2.adapter.ContainerAdapter;
import org.t2framework.t2.contexts.WebApplication;
import org.t2framework.t2.contexts.WebContext;
import org.t2framework.t2.plugin.AbstractPlugin;
import org.t2framework.t2.plugin.Plugin;
import org.t2framework.t2.plugin.PluginProcessor;
import org.t2framework.t2.spi.Navigation;

public class PluginProcessorImpl
implements PluginProcessor {
    protected final ContainerAdapter<?> containerAdapter;
    protected final Object lock = new Object();
    protected static Navigation DEFAULT_NAVIGATION = AbstractPlugin.PluginDefaultNavigation.INSTANCE;

    public PluginProcessorImpl(ContainerAdapter<?> containerAdapter) {
        this.containerAdapter = (ContainerAdapter)Assertion.notNull(containerAdapter);
    }

    @Override
    public void invokeInit(ServletContext servletContext, final WebApplication webApplication) {
        this.invoke0(servletContext, new Invoker<ServletContext>(){

            @Override
            public ServletContext invoke(Plugin plugin, ServletContext servletContext) {
                plugin.initialize(servletContext, webApplication);
                return servletContext;
            }
        });
    }

    @Override
    public void beginRequest(HttpServletRequest request, final HttpServletResponse response) {
        this.invoke0(request, new Invoker<HttpServletRequest>(){

            @Override
            public HttpServletRequest invoke(Plugin plugin, HttpServletRequest request) {
                plugin.beginRequestProcessing(request, response);
                return request;
            }
        });
    }

    @Override
    public void endRequest(HttpServletRequest request, final HttpServletResponse response) {
        this.invoke0(request, new Invoker<HttpServletRequest>(){

            @Override
            public HttpServletRequest invoke(Plugin plugin, HttpServletRequest request) {
                plugin.endRequestProcessing(request, response);
                return request;
            }
        });
    }

    @Override
    public HttpServletRequest createRequest(HttpServletRequest request, final HttpServletResponse response) {
        HttpServletRequest req = this.invoke0(request, new Invoker<HttpServletRequest>(){

            @Override
            public HttpServletRequest invoke(Plugin plugin, HttpServletRequest req) {
                return plugin.createRequest(req, response);
            }
        });
        return req;
    }

    @Override
    public HttpServletResponse createResponse(final HttpServletRequest request, HttpServletResponse response) {
        HttpServletResponse res = this.invoke0(response, new Invoker<HttpServletResponse>(){

            @Override
            public HttpServletResponse invoke(Plugin plugin, HttpServletResponse response) {
                return plugin.createResponse(request, response);
            }
        });
        return res;
    }

    @Override
    public Navigation invokeComponentCreated(final WebContext context, Object page) {
        return this.invokeNavigation(page, new NavigationInvoker<Object>(){

            @Override
            public Navigation invoke(Plugin plugin, Object param) {
                return plugin.componentCreated(context, param);
            }
        });
    }

    @Override
    public Navigation beforeActionInvoke(final ActionContext actionContext, final MethodDesc targetMethod, Object page, final Object[] args) {
        return this.invokeNavigation(page, new NavigationInvoker<Object>(){

            @Override
            public Navigation invoke(Plugin plugin, Object param) {
                return plugin.beforeActionInvoke(actionContext, targetMethod, param, args);
            }
        });
    }

    @Override
    public Navigation afterActionInvoke(final ActionContext actionContext, final MethodDesc targetMethod, Object page, final Object[] args) {
        return this.invokeNavigation(page, new NavigationInvoker<Object>(){

            @Override
            public Navigation invoke(Plugin plugin, Object param) {
                return plugin.afterActionInvoke(actionContext, targetMethod, param, args);
            }
        });
    }

    @Override
    public void beforeNavigation(WebContext context) {
        this.invoke0(context, new Invoker<WebContext>(){

            @Override
            public WebContext invoke(Plugin plugin, WebContext ctx) {
                plugin.beforeNavigation(ctx);
                return ctx;
            }
        });
    }

    @Override
    public void afterNavigation(WebContext context) {
        this.invoke0(context, new Invoker<WebContext>(){

            @Override
            public WebContext invoke(Plugin plugin, WebContext ctx) {
                plugin.afterNavigation(ctx);
                return ctx;
            }
        });
    }

    @Override
    public void destroy(ServletContext servletContext, final WebApplication webApplication) {
        this.invoke0(servletContext, new Invoker<ServletContext>(){

            @Override
            public ServletContext invoke(Plugin plugin, ServletContext servletContext) {
                plugin.destroy(servletContext, webApplication);
                return servletContext;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T invoke0(T org, Invoker<T> invoker) {
        T instance;
        if (!this.containerAdapter.hasComponent(Plugin.class)) {
            return org;
        }
        List<Plugin> plugins = this.getPlugins();
        if (plugins == null || plugins.isEmpty()) {
            return org;
        }
        T t = instance = org;
        synchronized (t) {
            for (Plugin p : plugins) {
                p.setContainerAdapter(this.containerAdapter);
                instance = invoker.invoke(p, instance);
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> Navigation invokeNavigation(T page, NavigationInvoker<T> invoker) {
        if (!this.containerAdapter.hasComponent(Plugin.class)) {
            return DEFAULT_NAVIGATION;
        }
        List<Plugin> plugins = this.getPlugins();
        if (plugins == null || plugins.isEmpty()) {
            return DEFAULT_NAVIGATION;
        }
        T param = page;
        Navigation navigation = DEFAULT_NAVIGATION;
        Object object = this.lock;
        synchronized (object) {
            for (Plugin p : plugins) {
                p.setContainerAdapter(this.containerAdapter);
                navigation = invoker.invoke(p, param);
                if (navigation == null || navigation.equals(DEFAULT_NAVIGATION)) continue;
                break;
            }
        }
        return navigation;
    }

    @Override
    public List<Plugin> getPlugins() {
        return this.containerAdapter.getComponents(Plugin.class);
    }

    private static interface NavigationInvoker<T> {
        public Navigation invoke(Plugin var1, T var2);
    }

    private static interface Invoker<T> {
        public T invoke(Plugin var1, T var2);
    }
}

