/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.navigation;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.t2framework.commons.util.Assertion;
import org.t2framework.commons.util.StreamUtil;
import org.t2framework.t2.spi.Navigation;

public abstract class StreamNavigation
implements Navigation {
    protected byte[] bytes;
    protected InputStream is;
    protected File file;

    public StreamNavigation(File file) {
        this.file = (File)Assertion.notNull((Object)file);
    }

    public StreamNavigation(InputStream is) {
        this.is = (InputStream)Assertion.notNull((Object)is);
    }

    public StreamNavigation(byte[] bytes) {
        this.bytes = (byte[])Assertion.notNull((Object)bytes);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    protected void writeTo(HttpServletResponse res, ServletOutputStream sos) throws IOException {
        if (this.is != null) {
            StreamUtil.copy((InputStream)this.is, (OutputStream)sos);
        } else if (this.file != null) {
            StreamUtil.copy((InputStream)StreamUtil.createBufferedFileInputStream((File)this.file), (OutputStream)sos);
        } else {
            byte[] bytes = this.getBytes();
            res.setContentLength(bytes.length);
            sos.write(bytes);
        }
    }
}

