/*
 * Decompiled with CFR 0.152.
 */
package org.t2framework.t2.contexts;

import java.util.Locale;
import org.t2framework.commons.Disposable;
import org.t2framework.commons.Disposer;
import org.t2framework.commons.util.Assertion;
import org.t2framework.t2.action.ActionContext;
import org.t2framework.t2.adapter.ContainerAdapter;
import org.t2framework.t2.contexts.Application;
import org.t2framework.t2.contexts.Context;
import org.t2framework.t2.contexts.Request;
import org.t2framework.t2.contexts.Response;
import org.t2framework.t2.contexts.Session;

public abstract class WebContext
implements Context<Request, Response, Application, Session> {
    protected static ThreadLocal<WebContext> pool = WebContext.createThreadLocal();
    protected Locale defaultLocale;
    protected ActionContext actionContext;
    protected ContainerAdapter<?> containerAdapter;

    public WebContext() {
        this(Locale.getDefault());
    }

    public WebContext(Locale defaultLocale) {
        Disposer.add((Disposable)new Disposable(){

            public void dispose() {
                pool.remove();
            }
        });
        this.defaultLocale = (Locale)Assertion.notNull((Object)defaultLocale);
    }

    public static void set(WebContext context) {
        pool.set((WebContext)Assertion.notNull((Object)context));
    }

    public static WebContext get() {
        return pool.get();
    }

    public static void clear() {
        pool.set(null);
    }

    private static <T> ThreadLocal<T> createThreadLocal() {
        return new ThreadLocal();
    }

    @Override
    public Locale getRequestLocale() {
        return ((Request)this.getRequest()).getLocale();
    }

    @Override
    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public void forward(String path) {
        Assertion.notNull((Object)path);
        ((Request)this.getRequest()).forward(path);
    }

    public void redirect(String path) {
        Assertion.notNull((Object)path);
        ((Response)this.getResponse()).redirect(path);
    }

    public ActionContext getActionContext() {
        return this.actionContext;
    }

    public void setActionContext(ActionContext actionContext) {
        this.actionContext = (ActionContext)Assertion.notNull((Object)actionContext);
    }

    public ContainerAdapter<?> getContainerAdapter() {
        return this.containerAdapter;
    }

    public void setContainerAdapter(ContainerAdapter<?> containerAdapter) {
        this.containerAdapter = containerAdapter;
    }
}

