/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.mvel2.ImmutableElementException;

public class FastList
extends AbstractList
implements Externalizable {
    private Object[] elements;
    private int size = 0;
    private boolean updated = false;

    public FastList(int size) {
        this.elements = new Object[size];
    }

    public FastList(Object[] elements) {
        this.elements = elements;
        this.size = elements.length;
    }

    public FastList() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            out.writeObject(this.elements[i]);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readInt();
        this.elements = new Object[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.elements[i] = in.readObject();
        }
    }

    public Object get(int index) {
        return this.elements[index];
    }

    public int size() {
        return this.size;
    }

    public boolean add(Object o) {
        if (this.size == this.elements.length) {
            this.increaseSize(this.elements.length * 2);
        }
        this.elements[this.size++] = o;
        return true;
    }

    public Object set(int i, Object o) {
        if (!this.updated) {
            this.copyArray();
        }
        Object old = this.elements[i];
        this.elements[i] = o;
        return old;
    }

    public void add(int i, Object o) {
        if (this.size == this.elements.length) {
            this.increaseSize(this.elements.length * 2);
        }
        for (int c = this.size; c != i; --c) {
            this.elements[c] = this.elements[c - 1];
        }
        this.elements[i] = o;
        ++this.size;
    }

    public Object remove(int i) {
        Object old = this.elements[i];
        for (int c = i + 1; c < this.size; ++c) {
            this.elements[c - 1] = this.elements[c];
            this.elements[c] = null;
        }
        --this.size;
        return old;
    }

    public int indexOf(Object o) {
        if (o == null) {
            return -1;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            if (!o.equals(this.elements[i])) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        if (o == null) {
            return -1;
        }
        for (int i = this.elements.length - 1; i != -1; --i) {
            if (!o.equals(this.elements[i])) continue;
            return i;
        }
        return -1;
    }

    public void clear() {
        this.elements = new Object[0];
    }

    public boolean addAll(int i, Collection collection) {
        int c;
        int offset = collection.size();
        this.ensureCapacity(offset);
        for (c = i; c != i + offset; ++c) {
            this.elements[c + offset + 1] = this.elements[c];
        }
        c = 0;
        for (Object o : collection) {
            this.elements[offset + c] = o;
        }
        return true;
    }

    public Iterator iterator() {
        final int size = this.size;
        return new Iterator(){
            private int cursor = 0;

            public boolean hasNext() {
                return this.cursor < size;
            }

            public Object next() {
                return FastList.this.elements[this.cursor++];
            }

            public void remove() {
                throw new ImmutableElementException("cannot change elements in immutable list");
            }
        };
    }

    public ListIterator listIterator() {
        return new ListIterator(){
            private int i = 0;

            public boolean hasNext() {
                return this.i < FastList.this.size;
            }

            public Object next() {
                return FastList.this.elements[this.i++];
            }

            public boolean hasPrevious() {
                return this.i > 0;
            }

            public Object previous() {
                return FastList.this.elements[this.i--];
            }

            public int nextIndex() {
                return this.i++;
            }

            public int previousIndex() {
                return this.i--;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void set(Object o) {
                ((FastList)FastList.this).elements[this.i] = 0;
            }

            public void add(Object o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public ListIterator listIterator(int i) {
        return super.listIterator(i);
    }

    public List subList(int i, int i1) {
        return super.subList(i, i1);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        ListIterator e1 = this.listIterator();
        ListIterator e2 = ((List)o).listIterator();
        while (e1.hasNext() && e2.hasNext()) {
            Object o1 = e1.next();
            Object o2 = e2.next();
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected void removeRange(int i, int i1) {
        throw new RuntimeException("not implemented");
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    public Object[] toArray() {
        if (!this.updated) {
            this.copyArray();
        }
        return this.elements;
    }

    public Object[] toArray(Object[] objects) {
        if (objects.length < this.size) {
            objects = new Object[this.size];
        }
        for (int i = 0; i < this.size; ++i) {
            objects[i] = this.elements[i];
        }
        return objects;
    }

    public boolean remove(Object o) {
        throw new RuntimeException("not implemented");
    }

    public boolean containsAll(Collection collection) {
        throw new RuntimeException("not implemented");
    }

    public boolean addAll(Collection collection) {
        return this.addAll(this.size, collection);
    }

    public boolean removeAll(Collection collection) {
        throw new RuntimeException("not implemented");
    }

    public boolean retainAll(Collection collection) {
        throw new RuntimeException("not implemented");
    }

    private void ensureCapacity(int additional) {
        if (this.size + additional > this.elements.length) {
            this.increaseSize((this.size + additional) * 2);
        }
    }

    private void copyArray() {
        this.increaseSize(this.elements.length);
    }

    private void increaseSize(int newSize) {
        Object[] newElements = new Object[newSize];
        for (int i = 0; i < this.elements.length; ++i) {
            newElements[i] = this.elements[i];
        }
        this.elements = newElements;
        this.updated = true;
    }

    public String toString() {
        return super.toString();
    }
}

