/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import java.util.Map;
import org.mvel2.CompileException;
import org.mvel2.ParserContext;
import org.mvel2.ast.ASTNode;
import org.mvel2.ast.Safe;
import org.mvel2.compiler.AbstractParser;
import org.mvel2.compiler.EndWithValue;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolver;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.DefaultLocalVariableResolverFactory;
import org.mvel2.integration.impl.FunctionVariableResolverFactory;
import org.mvel2.util.ParseTools;

public class Function
extends ASTNode
implements Safe {
    protected String name;
    protected ExecutableStatement compiledBlock;
    protected String[] parameters;
    protected int parmNum;

    public Function(String name, char[] parameters, char[] block, ParserContext pCtx) {
        this.name = name;
        if (this.name == null || name.length() == 0) {
            this.name = null;
        }
        this.parameters = ParseTools.parseParameterDefList(parameters, 0, parameters.length);
        this.parmNum = this.parameters.length;
        pCtx.declareFunction(this);
        ParserContext ctx = new ParserContext();
        ctx.getParserConfiguration().setImports(pCtx.getParserConfiguration().getImports());
        ctx.getParserConfiguration().setPackageImports(pCtx.getParserConfiguration().getPackageImports());
        ctx.setIndexAllocation(true);
        for (String s : this.parameters) {
            ctx.addVariable(s, Object.class);
            ctx.addIndexedVariable(s);
        }
        ParseTools.subCompileExpression(block, ctx);
        if (pCtx.getVariables() != null) {
            for (Map.Entry<String, Class> e : pCtx.getVariables().entrySet()) {
                ctx.addInput(e.getKey(), e.getValue());
            }
            ctx.processTables();
        }
        ctx.addIndexedVariables(ctx.getVariables().keySet());
        ctx.getVariables().clear();
        this.compiledBlock = (ExecutableStatement)ParseTools.subCompileExpression(block, ctx);
        AbstractParser.setCurrentThreadParserContext(pCtx);
        this.parameters = new String[ctx.getIndexedVariables().size()];
        int i = 0;
        for (String s : ctx.getIndexedVariables()) {
            this.parameters[i++] = s;
        }
        this.egressType = this.compiledBlock.getKnownEgressType();
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.name != null) {
            if (factory.isResolveable(this.name)) {
                throw new CompileException("duplicate function: " + this.name);
            }
            factory.createVariable(this.name, this);
        }
        return this;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.name != null) {
            if (factory.isResolveable(this.name)) {
                throw new CompileException("duplicate function: " + this.name);
            }
            factory.createVariable(this.name, this);
        }
        return this;
    }

    public Object call(Object ctx, Object thisValue, VariableResolverFactory factory, Object[] parms) {
        try {
            if (parms != null && parms.length != 0) {
                FunctionVariableResolverFactory fvrf;
                if (factory instanceof FunctionVariableResolverFactory && (fvrf = (FunctionVariableResolverFactory)factory).getFunction().equals(this)) {
                    VariableResolver[] swapVR = fvrf.getIndexedVariableResolvers();
                    fvrf.updateParameters(parms);
                    Object v = this.compiledBlock.getValue(ctx, thisValue, fvrf);
                    fvrf.setIndexedVariableResolvers(swapVR);
                    return v;
                }
                return this.compiledBlock.getValue(ctx, thisValue, new FunctionVariableResolverFactory(this, factory, this.parameters, parms));
            }
            return this.compiledBlock.getValue(ctx, thisValue, new DefaultLocalVariableResolverFactory(factory));
        }
        catch (EndWithValue end) {
            return end.getValue();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public void setParameters(String[] parameters) {
        this.parameters = parameters;
    }

    public boolean hasParameters() {
        return this.parameters != null && this.parameters.length != 0;
    }

    public void checkArgumentCount(int passing) {
        if (passing != this.parmNum) {
            throw new CompileException("bad number of arguments in function call: " + passing + " (expected: " + this.parmNum + ")");
        }
    }

    public ExecutableStatement getCompiledBlock() {
        return this.compiledBlock;
    }

    public String toString() {
        return "FunctionDef:" + (this.name == null ? "Anonymous" : this.name);
    }
}

